/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.container;

import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.portlet.container.PortletContainer;
import org.gatein.pc.portlet.container.PortletContainerContext;
import org.gatein.pc.portlet.container.managed.LifeCycleStatus;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.gatein.pc.portlet.container.managed.ManagedPortletContainer;
import org.gatein.pc.portlet.container.object.PortletContainerObject;
import org.gatein.pc.portlet.impl.container.DependencyNotResolvedException;
import org.gatein.pc.portlet.impl.container.LifeCycle;
import org.gatein.pc.portlet.impl.container.PortletApplicationLifeCycle;
import org.gatein.pc.portlet.impl.container.PortletFilterLifeCycle;

public class PortletContainerLifeCycle
extends LifeCycle
implements ManagedPortletContainer {
    private PortletApplicationLifeCycle portletApplicationLifeCycle;
    final PortletContainerContext portletContainerContext;
    final PortletContainerObject portletContainer;

    PortletContainerLifeCycle(PortletApplicationLifeCycle portletApplicationLifeCycle, PortletContainerContext portletContainerContext, PortletContainerObject portletContainer) {
        this.portletApplicationLifeCycle = portletApplicationLifeCycle;
        this.portletContainerContext = portletContainerContext;
        this.portletContainer = portletContainer;
    }

    protected void invokeStart() throws Exception {
        if (this.portletApplicationLifeCycle.getStatus() != LifeCycleStatus.STARTED) {
            throw new DependencyNotResolvedException("The parent application is not started");
        }
        for (PortletFilterLifeCycle portletFilterLifeCycle : this.portletApplicationLifeCycle.getDependencies(this)) {
            if (portletFilterLifeCycle.getStatus() == LifeCycleStatus.STARTED) continue;
            throw new DependencyNotResolvedException("The filter " + portletFilterLifeCycle + " is not started");
        }
        this.portletContainer.start();
    }

    protected void invokeStop() {
        this.portletContainer.stop();
    }

    public String getId() {
        return this.portletContainer.getId();
    }

    public PortletInfo getInfo() {
        return this.portletContainer.getInfo();
    }

    public PortletApplicationLifeCycle getManagedPortletApplication() {
        return this.portletApplicationLifeCycle;
    }

    public String toString() {
        return "PortletContainerLifeCycle[" + this.portletContainer.getId() + "]";
    }

    public PortletContainer getPortletContainer() {
        return this.portletContainer;
    }

    protected ManagedObjectRegistryEventListener getListener() {
        return this.portletApplicationLifeCycle.getListener();
    }
}

