/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.jboss.serial.io.JBossObjectInputStream;
import org.jboss.serial.io.JBossObjectOutputStream;

public class MarshalledObject
implements Serializable {
    private byte[] bytes;
    private int hash;
    static final long serialVersionUID = -1433248532959364465L;

    public MarshalledObject() {
    }

    public MarshalledObject(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JBossObjectOutputStream mvos = new JBossObjectOutputStream(baos);
        mvos.writeObject(obj);
        mvos.flush();
        this.bytes = baos.toByteArray();
        mvos.close();
        this.hash = 0;
        for (int i = 0; i < this.bytes.length; ++i) {
            this.hash += this.bytes[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.bytes);
        JBossObjectInputStream ois = new JBossObjectInputStream(bais);
        try {
            Object object = ois.readObject();
            return object;
        }
        finally {
            ois.close();
            bais.close();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarshalledObject that = (MarshalledObject)o;
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return this.hash;
    }
}

