/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads.metadata;

import java.lang.annotation.Annotation;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.jboss.aop.microcontainer.aspects.jmx.JMX;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.threads.ArrayQueue;
import org.jboss.threads.DirectExecutor;
import org.jboss.threads.InterruptHandler;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.JBossThreadFactory;
import org.jboss.threads.JBossThreadPoolExecutor;
import org.jboss.threads.RejectionPolicy;
import org.jboss.threads.SimpleQueueExecutor;
import org.jboss.threads.ThreadPoolExecutorMBean;
import org.jboss.threads.metadata.DirectExecutorMetaData;
import org.jboss.threads.metadata.ExceptionHandlerRefMetaData;
import org.jboss.threads.metadata.InterruptHandlerRefMetaData;
import org.jboss.threads.metadata.NotatingExecutorMetaData;
import org.jboss.threads.metadata.PoolSizeMetaData;
import org.jboss.threads.metadata.RejectPolicyMetaData;
import org.jboss.threads.metadata.ScheduledThreadPoolExecutorMetaData;
import org.jboss.threads.metadata.ThreadFactoryMetaData;
import org.jboss.threads.metadata.ThreadGroupMetaData;
import org.jboss.threads.metadata.ThreadPoolExecutorMetaData;
import org.jboss.threads.metadata.TimeMetaData;
import org.jboss.xb.annotations.JBossXmlSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JBossXmlSchema(namespace="urn:jboss:threads:1.0", elementFormDefault=XmlNsForm.QUALIFIED)
@XmlRootElement(name="threads")
@XmlType(name="threads")
public final class ThreadsMetaData
implements BeanMetaDataFactory {
    private static final Map<String, String> UNIT_NICK_NAMES = ThreadsMetaData.stringMap(ThreadsMetaData.entry("S", "SECONDS"), ThreadsMetaData.entry("SEC", "SECONDS"), ThreadsMetaData.entry("M", "MINUTES"), ThreadsMetaData.entry("MIN", "MINUTES"), ThreadsMetaData.entry("MS", "MILLISECONDS"), ThreadsMetaData.entry("NS", "NANOSECONDS"), ThreadsMetaData.entry("H", "HOURS"), ThreadsMetaData.entry("D", "DAYS"), ThreadsMetaData.entry("MON", "MONTHS"), ThreadsMetaData.entry("W", "WEEKS"));
    private List<ThreadGroupMetaData> threadGroups = new ArrayList<ThreadGroupMetaData>();
    private List<ThreadFactoryMetaData> threadFactories = new ArrayList<ThreadFactoryMetaData>();
    private List<ThreadPoolExecutorMetaData> threadPoolExecutors = new ArrayList<ThreadPoolExecutorMetaData>();
    private List<DirectExecutorMetaData> directExecutors = new ArrayList<DirectExecutorMetaData>();
    private List<NotatingExecutorMetaData> notatingExecutors = new ArrayList<NotatingExecutorMetaData>();
    private List<ScheduledThreadPoolExecutorMetaData> scheduledThreadPoolExecutors = new ArrayList<ScheduledThreadPoolExecutorMetaData>();

    private static StringEntry entry(String key, String value) {
        return new StringEntry(key, value);
    }

    private static Map<String, String> stringMap(StringEntry ... entries) {
        HashMap hashMap = new HashMap(entries.length);
        for (StringEntry e : entries) {
            hashMap.put(e.getKey(), e.getValue());
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public List<ThreadGroupMetaData> getThreadGroups() {
        return this.threadGroups;
    }

    @XmlElement(name="thread-group")
    public void setThreadGroups(List<ThreadGroupMetaData> threadGroups) {
        this.threadGroups = threadGroups;
    }

    public List<ThreadFactoryMetaData> getThreadFactories() {
        return this.threadFactories;
    }

    @XmlElement(name="thread-factory")
    public void setThreadFactories(List<ThreadFactoryMetaData> threadFactories) {
        this.threadFactories = threadFactories;
    }

    public List<ThreadPoolExecutorMetaData> getThreadPoolExecutors() {
        return this.threadPoolExecutors;
    }

    @XmlElement(name="thread-pool-executor")
    public void setThreadPoolExecutors(List<ThreadPoolExecutorMetaData> threadPoolExecutors) {
        this.threadPoolExecutors = threadPoolExecutors;
    }

    public List<DirectExecutorMetaData> getDirectExecutors() {
        return this.directExecutors;
    }

    @XmlElement(name="direct-executor")
    public void setDirectExecutors(List<DirectExecutorMetaData> directExecutors) {
        this.directExecutors = directExecutors;
    }

    public List<NotatingExecutorMetaData> getNotatingExecutors() {
        return this.notatingExecutors;
    }

    @XmlElement(name="notating-executor")
    public void setNotatingExecutors(List<NotatingExecutorMetaData> notatingExecutors) {
        this.notatingExecutors = notatingExecutors;
    }

    public List<ScheduledThreadPoolExecutorMetaData> getScheduledThreadPoolExecutors() {
        return this.scheduledThreadPoolExecutors;
    }

    @XmlElement(name="scheduled-thread-pool-executor")
    public void setScheduledThreadPoolExecutors(List<ScheduledThreadPoolExecutorMetaData> scheduledThreadPoolExecutors) {
        this.scheduledThreadPoolExecutors = scheduledThreadPoolExecutors;
    }

    @XmlTransient
    public List<BeanMetaData> getBeans() {
        BeanMetaDataBuilder builder;
        String name;
        ArrayList<BeanMetaData> beanMetaDataList = new ArrayList<BeanMetaData>();
        for (ThreadGroupMetaData threadGroupMetaData : this.threadGroups) {
            Integer maxPriorityMeta;
            name = threadGroupMetaData.getName();
            builder = BeanMetaDataBuilder.createBuilder((String)name, (String)ThreadGroup.class.getName());
            builder.setMode(ControllerMode.ON_DEMAND);
            String parent = threadGroupMetaData.getParent();
            if (parent != null && parent.length() > 0) {
                builder.addConstructorParameter(ThreadGroup.class.getName(), builder.createInject((Object)parent));
            }
            builder.addConstructorParameter(String.class.getName(), builder.createValue((Object)name));
            if (threadGroupMetaData.isDaemon() != null) {
                builder.addPropertyMetaData("daemon", builder.createValue((Object)threadGroupMetaData.isDaemon()));
            }
            if ((maxPriorityMeta = threadGroupMetaData.getMaxPriority()) != null) {
                builder.addPropertyMetaData("maxPriority", builder.createValue((Object)maxPriorityMeta));
            }
            builder.ignoreStop();
            builder.ignoreDestroy();
            beanMetaDataList.add(builder.getBeanMetaData());
        }
        for (ThreadFactoryMetaData threadFactoryMetaData : this.threadFactories) {
            name = threadFactoryMetaData.getName();
            builder = BeanMetaDataBuilder.createBuilder((String)name, (String)JBossThreadFactory.class.getName());
            builder.setMode(ControllerMode.ON_DEMAND);
            String group = threadFactoryMetaData.getGroup();
            builder.addConstructorParameter(ThreadGroup.class.getName(), group == null ? builder.createNull() : builder.createInject((Object)group));
            Boolean daemon = threadFactoryMetaData.getDaemon();
            builder.addConstructorParameter(Boolean.class.getName(), daemon == null ? builder.createNull() : builder.createValue((Object)daemon));
            Integer priorityMeta = threadFactoryMetaData.getInitialPriority();
            Integer actualPriorityMeta = priorityMeta != null ? priorityMeta : null;
            builder.addConstructorParameter(Integer.class.getName(), actualPriorityMeta == null ? builder.createNull() : builder.createValue((Object)actualPriorityMeta));
            builder.addConstructorParameter(String.class.getName(), builder.createValue((Object)threadFactoryMetaData.getThreadNamePattern()));
            List interruptHandlers = builder.createArray(InterruptHandler[].class.getName(), InterruptHandler.class.getName());
            for (InterruptHandlerRefMetaData ihmd : threadFactoryMetaData.getInterruptHandlers()) {
                interruptHandlers.add(builder.createInject((Object)ihmd.getName()));
            }
            builder.addConstructorParameter(InterruptHandler[].class.getName(), (ValueMetaData)interruptHandlers);
            ExceptionHandlerRefMetaData ehmd = threadFactoryMetaData.getExceptionHandler();
            builder.addConstructorParameter(Thread.UncaughtExceptionHandler.class.getName(), ehmd == null ? builder.createNull() : builder.createInject((Object)ehmd.getName()));
            Long stackSize = threadFactoryMetaData.getStackSize();
            builder.addConstructorParameter(Long.class.getName(), stackSize == null ? builder.createNull() : builder.createValue((Object)stackSize));
            beanMetaDataList.add(builder.getBeanMetaData());
        }
        for (ThreadPoolExecutorMetaData threadPoolExecutorMetaData : this.threadPoolExecutors) {
            BeanMetaDataBuilder executorBuilder;
            String policyName;
            TimeUnit unit;
            long time;
            name = threadPoolExecutorMetaData.getName();
            PoolSizeMetaData corePoolSizeMetaData = threadPoolExecutorMetaData.getCorePoolSize();
            int corePoolSize = corePoolSizeMetaData == null ? 0 : Math.max(ThreadsMetaData.calcPoolSize(corePoolSizeMetaData), 0);
            PoolSizeMetaData maxPoolSizeMetaData = threadPoolExecutorMetaData.getMaxPoolSize();
            int maxPoolSize = maxPoolSizeMetaData == null ? Math.max(corePoolSize, 1) : Math.max(ThreadsMetaData.calcPoolSize(maxPoolSizeMetaData), Math.max(1, corePoolSize));
            TimeMetaData timeMetaData = threadPoolExecutorMetaData.getKeepAliveTime();
            if (timeMetaData == null) {
                time = Long.MAX_VALUE;
                unit = TimeUnit.NANOSECONDS;
            } else {
                String upperUnitName;
                time = Math.max(0L, timeMetaData.getTime());
                String unitName = timeMetaData.getUnit();
                unit = unitName == null ? TimeUnit.MILLISECONDS : (UNIT_NICK_NAMES.containsKey(upperUnitName = unitName.toUpperCase()) ? TimeUnit.valueOf(UNIT_NICK_NAMES.get(upperUnitName)) : TimeUnit.valueOf(upperUnitName));
            }
            String threadFactory = threadPoolExecutorMetaData.getThreadFactory();
            if (threadFactory == null) {
                throw new IllegalArgumentException("threadFactory is not defined");
            }
            Integer queueLength = threadPoolExecutorMetaData.getQueueLength();
            RejectPolicyMetaData rejectPolicyMetaData = threadPoolExecutorMetaData.getRejectPolicyMetaData();
            String string = policyName = rejectPolicyMetaData == null ? "block" : rejectPolicyMetaData.getName();
            if (threadPoolExecutorMetaData.isAllowCoreTimeout() || "block".equals(policyName)) {
                ValueMetaData handoffExecutorValue;
                RejectionPolicy rejectionPolicy;
                executorBuilder = BeanMetaDataBuilder.createBuilder((String)SimpleQueueExecutor.class.getName());
                if ("abort".equals(policyName)) {
                    rejectionPolicy = RejectionPolicy.ABORT;
                    handoffExecutorValue = executorBuilder.createNull();
                } else if ("block".equals(policyName)) {
                    rejectionPolicy = RejectionPolicy.BLOCK;
                    handoffExecutorValue = executorBuilder.createNull();
                } else if ("caller-runs".equals(policyName)) {
                    rejectionPolicy = RejectionPolicy.HANDOFF;
                    handoffExecutorValue = executorBuilder.createValue((Object)JBossExecutors.directExecutor());
                } else if ("discard".equals(policyName)) {
                    rejectionPolicy = RejectionPolicy.DISCARD;
                    handoffExecutorValue = executorBuilder.createNull();
                } else if ("discard-oldest".equals(policyName)) {
                    rejectionPolicy = RejectionPolicy.DISCARD_OLDEST;
                    handoffExecutorValue = executorBuilder.createNull();
                } else if ("handoff".equals(policyName)) {
                    rejectionPolicy = RejectionPolicy.HANDOFF;
                    handoffExecutorValue = executorBuilder.createInject((Object)rejectPolicyMetaData.getExecutorName());
                } else {
                    throw new IllegalStateException();
                }
                ArrayQueue queue = queueLength == null ? new LinkedList() : new ArrayQueue(queueLength.intValue());
                executorBuilder.addConstructorParameter(String.class.getName(), name);
                executorBuilder.addConstructorParameter("int", (Object)corePoolSize);
                executorBuilder.addConstructorParameter("int", (Object)maxPoolSize);
                executorBuilder.addConstructorParameter("long", (Object)time);
                executorBuilder.addConstructorParameter(TimeUnit.class.getName(), (Object)unit);
                executorBuilder.addConstructorParameter(Queue.class.getName(), executorBuilder.createValue((Object)queue));
                executorBuilder.addConstructorParameter(ThreadFactory.class.getName(), executorBuilder.createInject((Object)threadFactory));
                executorBuilder.addConstructorParameter(RejectionPolicy.class.getName(), (Object)rejectionPolicy);
                executorBuilder.addConstructorParameter(Executor.class.getName(), handoffExecutorValue);
                if (threadPoolExecutorMetaData.isAllowCoreTimeout()) {
                    executorBuilder.addPropertyMetaData("allowCoreTimeout", (Object)Boolean.TRUE);
                }
            } else {
                ValueMetaData policyValue;
                executorBuilder = BeanMetaDataBuilder.createBuilder((String)JBossThreadPoolExecutor.class.getName());
                if ("abort".equals(policyName)) {
                    policyValue = executorBuilder.createValue((Object)JBossExecutors.abortPolicy());
                } else {
                    if ("block".equals(policyName)) {
                        throw new IllegalStateException();
                    }
                    if ("caller-runs".equals(policyName)) {
                        policyValue = executorBuilder.createValue((Object)JBossExecutors.callerRunsPolicy());
                    } else if ("discard".equals(policyName)) {
                        policyValue = executorBuilder.createValue((Object)JBossExecutors.discardPolicy());
                    } else if ("discard-oldest".equals(policyName)) {
                        policyValue = executorBuilder.createValue((Object)JBossExecutors.discardOldestPolicy());
                    } else if ("handoff".equals(policyName)) {
                        BeanMetaDataBuilder policyBuilder = BeanMetaDataBuilder.createBuilder((String)RejectedExecutionHandler.class.getName());
                        policyBuilder.setFactoryClass(JBossExecutors.class.getName());
                        policyBuilder.setFactoryMethod("handoffPolicy");
                        policyBuilder.addConstructorParameter(Executor.class.getName(), policyBuilder.createInject((Object)rejectPolicyMetaData.getExecutorName()));
                        policyValue = policyBuilder.getBeanMetaData();
                    } else {
                        throw new IllegalStateException();
                    }
                }
                AbstractQueue queue = queueLength == null ? new LinkedBlockingQueue() : new ArrayBlockingQueue(queueLength);
                executorBuilder.addConstructorParameter(String.class.getName(), name);
                executorBuilder.addConstructorParameter("int", (Object)corePoolSize);
                executorBuilder.addConstructorParameter("int", (Object)maxPoolSize);
                executorBuilder.addConstructorParameter("long", (Object)time);
                executorBuilder.addConstructorParameter(TimeUnit.class.getName(), (Object)unit);
                executorBuilder.addConstructorParameter(BlockingQueue.class.getName(), executorBuilder.createValue(queue));
                executorBuilder.addConstructorParameter(ThreadFactory.class.getName(), executorBuilder.createInject((Object)threadFactory));
                executorBuilder.addConstructorParameter(RejectedExecutionHandler.class.getName(), policyValue);
            }
            executorBuilder.addAnnotation((Annotation)new JMX(){

                public Class<?> exposedInterface() {
                    return ThreadPoolExecutorMBean.class;
                }

                public String name() {
                    return "jboss.threads:service=ThreadPoolExecutor,name=" + name;
                }

                public boolean registerDirectly() {
                    return false;
                }

                public Class<? extends Annotation> annotationType() {
                    return JMX.class;
                }
            });
            executorBuilder.setMode(ControllerMode.ON_DEMAND);
            executorBuilder.setName(name);
            beanMetaDataList.add(executorBuilder.getBeanMetaData());
        }
        for (DirectExecutorMetaData directExecutorMetaData : this.directExecutors) {
            name = directExecutorMetaData.getName();
            builder = BeanMetaDataBuilder.createBuilder((String)name, (String)ExecutorService.class.getName());
            builder.setFactoryClass(JBossExecutors.class.getName());
            builder.setFactoryMethod("directExecutorService");
            builder.setMode(ControllerMode.ON_DEMAND);
            beanMetaDataList.add(builder.getBeanMetaData());
        }
        for (NotatingExecutorMetaData notatingExecutorMetaData : this.notatingExecutors) {
            name = notatingExecutorMetaData.getName();
            builder = BeanMetaDataBuilder.createBuilder((String)name, (String)DirectExecutor.class.getName());
            builder.setMode(ControllerMode.ON_DEMAND);
            builder.setFactoryClass(JBossExecutors.class.getName());
            builder.setFactoryMethod("notatingExecutor");
            builder.addConstructorParameter(Executor.class.getName(), builder.createInject((Object)notatingExecutorMetaData.getParent()));
            builder.addConstructorParameter(String.class.getName(), notatingExecutorMetaData.getNote());
            beanMetaDataList.add(builder.getBeanMetaData());
        }
        for (ScheduledThreadPoolExecutorMetaData scheduledThreadPoolExecutorMetaData : this.scheduledThreadPoolExecutors) {
            name = scheduledThreadPoolExecutorMetaData.getName();
            builder = BeanMetaDataBuilder.createBuilder((String)name, (String)ScheduledThreadPoolExecutor.class.getName());
            builder.setMode(ControllerMode.ON_DEMAND);
            PoolSizeMetaData poolSizeMetaData = scheduledThreadPoolExecutorMetaData.getPoolSize();
            int size = poolSizeMetaData != null ? Math.max(1, ThreadsMetaData.calcPoolSize(poolSizeMetaData)) : 1;
            builder.addConstructorParameter("int", (Object)size);
            String threadFactoryName = scheduledThreadPoolExecutorMetaData.getThreadFactory();
            if (threadFactoryName != null) {
                builder.addConstructorParameter(ThreadFactory.class.getName(), builder.createInject((Object)threadFactoryName));
            }
            beanMetaDataList.add(builder.getBeanMetaData());
        }
        return beanMetaDataList;
    }

    private static int calcPoolSize(PoolSizeMetaData poolSizeMetaData) {
        float count = poolSizeMetaData.getCount();
        float perCpu = poolSizeMetaData.getPerCpu();
        if (Float.isNaN(count) || Float.isInfinite(count) || count < 0.0f) {
            count = 0.0f;
        }
        if (Float.isNaN(perCpu) || Float.isInfinite(perCpu) || perCpu < 0.0f) {
            perCpu = 0.0f;
        }
        return Math.round(count + (float)Runtime.getRuntime().availableProcessors() * perCpu);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StringEntry
    implements Map.Entry<String, String> {
        private final String key;
        private final String value;

        private StringEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }
    }
}

