/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.agent;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.Notification;
import org.jboss.jmx.adaptor.snmp.agent.Clock;
import org.jboss.jmx.adaptor.snmp.agent.Counter;
import org.jboss.jmx.adaptor.snmp.agent.DynamicContentAccessor;
import org.jboss.jmx.adaptor.snmp.agent.MappingFailedException;
import org.jboss.jmx.adaptor.snmp.agent.NotificationWrapper;

public class NotificationWrapperSupport
implements NotificationWrapper {
    protected Map payload = new HashMap();
    protected Clock clock;
    protected Counter trapCount;

    public void set(Clock uptime, Counter count) {
        this.clock = uptime;
        this.trapCount = count;
        this.payload.put("a:startTime", new Date(this.clock.instantiationTime()));
        this.payload.put("a:uptime", new DynamicContentAccessor(){

            public Object get() {
                return new Long(NotificationWrapperSupport.this.clock.uptime());
            }
        });
        this.payload.put("a:trapCount", new DynamicContentAccessor(){

            public Object get() {
                return new Long(NotificationWrapperSupport.this.trapCount.peek());
            }
        });
    }

    public void prime(Notification n) {
        this.payload.put("n:message", n.getMessage());
        this.payload.put("n:sequenceNumber", new Long(n.getSequenceNumber()));
        this.payload.put("n:timeStamp", new Long(n.getTimeStamp()));
        this.payload.put("n:type", n.getType());
        this.payload.put("n:all", n.toString());
        this.payload.put("n:class", n.getClass().getName());
        Object userData = n.getUserData();
        if (userData instanceof HashMap) {
            this.payload.putAll((HashMap)userData);
        }
    }

    public Object get(String tagName) throws MappingFailedException {
        Object o = this.payload.get(tagName);
        if (o == null) {
            throw new MappingFailedException("Tag \"" + tagName + "\" not found");
        }
        if (o instanceof DynamicContentAccessor) {
            DynamicContentAccessor d = (DynamicContentAccessor)o;
            return d.get();
        }
        return o;
    }
}

