/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.simple;

import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;

public class SimpleClient {
    private static String transport = "socket";
    private static String host = "localhost";
    private static int port = 5400;

    public void makeInvocation(String locatorURI) throws Throwable {
        InvokerLocator locator = new InvokerLocator(locatorURI);
        System.out.println("Calling remoting server with locator uri of: " + locatorURI);
        Client remotingClient = new Client(locator);
        remotingClient.connect();
        String request = "Do something";
        System.out.println("Invoking server with request of '" + request + "'");
        Object response = remotingClient.invoke(request);
        remotingClient.disconnect();
        System.out.println("Invocation response: " + response);
    }

    public static void main(String[] args) {
        if (args != null && args.length == 3) {
            transport = args[0];
            host = args[1];
            port = Integer.parseInt(args[2]);
        }
        String locatorURI = transport + "://" + host + ":" + port;
        SimpleClient client = new SimpleClient();
        try {
            client.makeInvocation(locatorURI);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

