/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.protocol.jarjar;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.ejb3.protocol.jarjar.JarJarInputStream;
import org.jboss.logging.Logger;

public class JarJarURLConnection
extends URLConnection {
    private static final Logger log = Logger.getLogger(JarJarURLConnection.class);
    private URL delegate;
    private JarFile jarFile;
    private JarEntry rootEntry;

    protected JarJarURLConnection(URL url) {
        super(url);
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.delegate = new URL(this.getURL().toString().substring(7));
        log.debug((Object)("delegate " + this.delegate));
        JarURLConnection conn = (JarURLConnection)this.delegate.openConnection();
        this.jarFile = conn.getJarFile();
        log.trace((Object)("jar file " + this.jarFile));
        this.rootEntry = conn.getJarEntry();
        log.trace((Object)("root entry " + this.rootEntry));
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        String spec = this.delegate.toString();
        URL jarFileURL = this.rootEntry != null ? new URL(spec.substring(0, spec.length() - this.rootEntry.getName().length())) : this.delegate;
        log.debug((Object)("jar file url " + jarFileURL));
        return new JarJarInputStream(this.jarFile, this.rootEntry);
    }
}

