/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import net.oauth.OAuthConsumer;
import net.oauth.OAuthServiceProvider;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.gadgets.GadgetException;

public interface OAuthStore {
    public ConsumerInfo getConsumerKeyAndSecret(SecurityToken var1, String var2, OAuthServiceProvider var3) throws GadgetException;

    public TokenInfo getTokenInfo(SecurityToken var1, ConsumerInfo var2, String var3, String var4) throws GadgetException;

    public void setTokenInfo(SecurityToken var1, ConsumerInfo var2, String var3, String var4, TokenInfo var5) throws GadgetException;

    public void removeToken(SecurityToken var1, ConsumerInfo var2, String var3, String var4) throws GadgetException;

    public static class TokenInfo {
        private final String accessToken;
        private final String tokenSecret;
        private final String sessionHandle;
        private final long tokenExpireMillis;

        public TokenInfo(String accessToken, String tokenSecret, String sessionHandle, long tokenExpireMillis) {
            this.accessToken = accessToken;
            this.tokenSecret = tokenSecret;
            this.sessionHandle = sessionHandle;
            this.tokenExpireMillis = tokenExpireMillis;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getTokenSecret() {
            return this.tokenSecret;
        }

        public String getSessionHandle() {
            return this.sessionHandle;
        }

        public long getTokenExpireMillis() {
            return this.tokenExpireMillis;
        }
    }

    public static class ConsumerInfo {
        private final OAuthConsumer consumer;
        private final String keyName;
        private final String callbackUrl;

        public ConsumerInfo(OAuthConsumer consumer, String keyName, String callbackUrl) {
            this.consumer = consumer;
            this.keyName = keyName;
            this.callbackUrl = callbackUrl;
        }

        public OAuthConsumer getConsumer() {
            return this.consumer;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public String getCallbackUrl() {
            return this.callbackUrl;
        }
    }
}

