/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.mc;

import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.pc.mc.PortletApplicationContextImpl;
import org.gatein.pc.mc.PortletContainerContextImpl;
import org.gatein.pc.mc.PortletFilterContextImpl;
import org.gatein.pc.portlet.container.PortletApplicationContext;
import org.gatein.pc.portlet.container.PortletContainerContext;
import org.gatein.pc.portlet.container.PortletFilterContext;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.gatein.pc.portlet.container.object.PortletApplicationObject;
import org.gatein.pc.portlet.container.object.PortletContainerObject;
import org.gatein.pc.portlet.container.object.PortletFilterObject;
import org.gatein.pc.portlet.impl.container.PortletApplicationLifeCycle;
import org.gatein.pc.portlet.impl.container.PortletContainerLifeCycle;
import org.gatein.pc.portlet.impl.container.PortletFilterLifeCycle;
import org.gatein.pc.portlet.impl.info.ContainerFilterInfo;
import org.gatein.pc.portlet.impl.info.ContainerInfoBuilder;
import org.gatein.pc.portlet.impl.info.ContainerInfoBuilderContext;
import org.gatein.pc.portlet.impl.info.ContainerPortletInfo;
import org.gatein.pc.portlet.impl.jsr168.ContainerInfoBuilderContextImpl;
import org.gatein.pc.portlet.impl.jsr168.PortletApplicationImpl;
import org.gatein.pc.portlet.impl.jsr168.PortletContainerImpl;
import org.gatein.pc.portlet.impl.jsr168.PortletFilterImpl;
import org.gatein.pc.portlet.impl.metadata.PortletApplication10MetaData;
import org.gatein.wci.WebApp;

public class PortletApplicationDeployment {
    private final Logger log;
    private final WebApp webApp;
    private final PortletApplication10MetaData metaData;
    private final ManagedObjectRegistryEventListener listener;
    private PortletApplicationLifeCycle portletApplicationLifeCycle;

    public PortletApplicationDeployment(ManagedObjectRegistryEventListener listener, WebApp webApp, PortletApplication10MetaData metaData) {
        this.listener = listener;
        this.webApp = webApp;
        this.metaData = metaData;
        this.log = LoggerFactory.getLogger((String)(PortletApplicationDeployment.class + "." + webApp.getContextPath().replace('.', '_')));
    }

    public PortletApplicationLifeCycle getPortletApplicationLifeCycle() {
        return this.portletApplicationLifeCycle;
    }

    void install() {
        this.log.debug((Object)"Starting installation");
        ContainerInfoBuilderContextImpl builderContext = new ContainerInfoBuilderContextImpl(this.metaData, this.webApp);
        ContainerInfoBuilder builder = new ContainerInfoBuilder(this.webApp.getContextPath(), this.metaData, (ContainerInfoBuilderContext)builderContext);
        builder.build();
        PortletApplicationImpl portletApplicationObject = new PortletApplicationImpl(builder.getApplication());
        PortletApplicationContextImpl portletApplicationContext = new PortletApplicationContextImpl(this.webApp);
        this.portletApplicationLifeCycle = new PortletApplicationLifeCycle(this.listener, (PortletApplicationContext)portletApplicationContext, (PortletApplicationObject)portletApplicationObject);
        portletApplicationContext.managedPortletApplication = this.portletApplicationLifeCycle;
        for (ContainerFilterInfo filterInfo : builder.getApplication().getFilters().values()) {
            PortletFilterImpl portletFilterObject = new PortletFilterImpl(filterInfo);
            PortletFilterContextImpl portletFilterContext = new PortletFilterContextImpl();
            PortletFilterLifeCycle portletFilterLifeCycle = this.portletApplicationLifeCycle.addPortletFilter((PortletFilterContext)portletFilterContext, (PortletFilterObject)portletFilterObject);
            portletFilterContext.managedPortletFilter = portletFilterLifeCycle;
        }
        for (ContainerPortletInfo containerInfo : builder.getPortlets()) {
            PortletContainerImpl portletContainerObject = new PortletContainerImpl(containerInfo);
            PortletContainerContextImpl portletContainerContext = new PortletContainerContextImpl();
            PortletContainerLifeCycle portletContainerLifeCycle = this.portletApplicationLifeCycle.addPortletContainer((PortletContainerContext)portletContainerContext, (PortletContainerObject)portletContainerObject);
            portletContainerContext.managedPortletContainer = portletContainerLifeCycle;
            for (String filterRef : containerInfo.getFilterRefs()) {
                PortletFilterLifeCycle portletFilterLifeCycle = this.portletApplicationLifeCycle.getManagedPortletFilter(filterRef);
                if (portletFilterLifeCycle == null) continue;
                this.portletApplicationLifeCycle.addDependency(portletFilterLifeCycle, portletContainerLifeCycle);
            }
        }
        this.portletApplicationLifeCycle.create();
        this.portletApplicationLifeCycle.managedStart();
    }

    void uninstall() {
        this.log.debug((Object)"Uninstalling");
        this.portletApplicationLifeCycle.managedStop();
        this.log.debug((Object)"Uninstalled");
    }
}

