/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.serialization.serial;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;

public class DataContainer
implements Externalizable {
    private final LinkedList<Object> structure = new LinkedList();

    public void writeInt(int i) {
        this.structure.add(i);
    }

    public void writeObject(Object o) {
        this.structure.add(o);
    }

    public int readInt() {
        return (Integer)this.structure.removeFirst();
    }

    public Object readObject() {
        return this.structure.removeFirst();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.structure.size());
        for (Object e : this.structure) {
            out.writeObject(e);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        while (size-- > 0) {
            this.structure.addLast(in.readObject());
        }
    }

    public String toString() {
        return "DataContainer[" + this.structure + "]";
    }
}

