/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.serialization;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectReader;
import org.exoplatform.services.jcr.dataflow.serialization.SerializationConstants;
import org.exoplatform.services.jcr.dataflow.serialization.UnknownClassIdException;
import org.exoplatform.services.jcr.impl.dataflow.AbstractPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ByteArrayPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.FilePersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ReaderSpoolFileHolder;
import org.exoplatform.services.jcr.impl.dataflow.serialization.SerializationSpoolFile;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.SpoolFile;

public class PersistedValueDataReader {
    private final FileCleaner fileCleaner;
    private final int maxBufferSize;
    private final ReaderSpoolFileHolder holder;

    public PersistedValueDataReader(FileCleaner fileCleaner, int maxBufferSize, ReaderSpoolFileHolder holder) {
        this.fileCleaner = fileCleaner;
        this.maxBufferSize = maxBufferSize;
        this.holder = holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractPersistedValueData read(ObjectReader in) throws UnknownClassIdException, IOException {
        FilePersistedValueData filePersistedValueData;
        File tempDirectory = new File(SerializationConstants.TEMP_DIR);
        tempDirectory.mkdirs();
        int key = in.readInt();
        if (key != 11) {
            throw new UnknownClassIdException("There is unexpected class [" + key + "]");
        }
        int orderNumber = in.readInt();
        boolean isByteArray = in.readBoolean();
        if (isByteArray) {
            byte[] data = new byte[in.readInt()];
            in.readFully(data);
            return new ByteArrayPersistedValueData(orderNumber, data);
        }
        String id = in.readString();
        long length = in.readLong();
        SerializationSpoolFile sf = this.holder.get(id);
        if (sf == null) {
            sf = new SerializationSpoolFile(tempDirectory, id, this.holder);
            this.writeToFile(in, sf, length);
            this.holder.put(id, sf);
            return new FilePersistedValueData(orderNumber, sf);
        }
        sf.acquire(this);
        try {
            FilePersistedValueData vd = new FilePersistedValueData(orderNumber, sf);
            if (in.skip(length) != length) {
                throw new IOException("Content isn't skipped correctly.");
            }
            filePersistedValueData = vd;
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            sf.release(this);
            throw throwable;
        }
        sf.release(this);
        return filePersistedValueData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(ObjectReader src, SpoolFile dest, long length) throws IOException {
        FileOutputStream sfout = new FileOutputStream(dest);
        int bSize = 2048;
        try {
            byte[] buff = new byte[bSize];
            while (length >= (long)bSize) {
                src.readFully(buff);
                sfout.write(buff);
                length -= (long)bSize;
            }
            if (length > 0L) {
                buff = new byte[(int)length];
                src.readFully(buff);
                sfout.write(buff);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            sfout.close();
            throw throwable;
        }
        sfout.close();
    }
}

