/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.strategy;

import org.apache.commons.betwixt.strategy.NameMapper;

public class HyphenatedNameMapper
implements NameMapper {
    private String separator = "-";
    private boolean upperCase = false;

    public HyphenatedNameMapper() {
    }

    public HyphenatedNameMapper(boolean upperCase) {
        this.upperCase = upperCase;
    }

    public HyphenatedNameMapper(boolean upperCase, String separator) {
        this.upperCase = upperCase;
        this.separator = separator;
    }

    public String mapTypeToElementName(String typeName) {
        int length = typeName.length();
        if (length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.convertChar(typeName.charAt(0)));
        for (int i = 1; i < length; ++i) {
            if (Character.isUpperCase(typeName.charAt(i))) {
                sb.append(this.separator);
                sb.append(this.convertChar(typeName.charAt(i)));
                continue;
            }
            if (this.upperCase) {
                sb.append(this.convertChar(typeName.charAt(i)));
                continue;
            }
            sb.append(typeName.charAt(i));
        }
        return sb.toString();
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public boolean isUpperCase() {
        return this.upperCase;
    }

    public void setUpperCase(boolean upperCase) {
        this.upperCase = upperCase;
    }

    protected char convertChar(char ch) {
        if (this.upperCase) {
            return Character.toUpperCase(ch);
        }
        return Character.toLowerCase(ch);
    }

    public String toString() {
        return "Hyphenated Name Mapper";
    }
}

