/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.Directory;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexFormatVersion;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrStandartAnalyzer;
import org.exoplatform.services.jcr.impl.core.query.lucene.PersistentIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.ReadOnlyIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.DirectoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexMigration {
    private static final Logger log = LoggerFactory.getLogger(IndexMigration.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void migrate(PersistentIndex index, DirectoryManager directoryManager) throws IOException {
        Directory indexDir = index.getDirectory();
        log.debug("Checking {} ...", (Object)indexDir);
        ReadOnlyIndexReader reader = index.getReadOnlyIndexReader();
        try {
            TermEnum terms;
            block14: {
                if (IndexFormatVersion.getVersion((IndexReader)reader).getVersion() >= IndexFormatVersion.V3.getVersion()) {
                    log.debug("IndexFormatVersion >= V3, no migration needed");
                    Object var9_4 = null;
                    reader.release();
                    index.releaseWriterAndReaders();
                    return;
                }
                terms = reader.terms(new Term(FieldNames.PROPERTIES, ""));
                try {
                    Term t = terms.term();
                    if (t.text().indexOf(65535) != -1) break block14;
                    log.debug("Index already migrated");
                    Object var7_10 = null;
                }
                catch (Throwable throwable) {
                    Object var7_12 = null;
                    terms.close();
                    throw throwable;
                }
                terms.close();
                Object var9_5 = null;
                reader.release();
                index.releaseWriterAndReaders();
                return;
            }
            Object var7_11 = null;
            terms.close();
            Object var9_6 = null;
            reader.release();
            index.releaseWriterAndReaders();
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            reader.release();
            index.releaseWriterAndReaders();
            throw throwable;
        }
        log.debug("Index requires migration {}", (Object)indexDir);
        String migrationName = index.getName() + "_v2.3";
        if (directoryManager.hasDirectory(migrationName)) {
            directoryManager.delete(migrationName);
        }
        Directory migrationDir = directoryManager.getDirectory(migrationName);
        try {
            IndexWriter writer = new IndexWriter(migrationDir, (Analyzer)new JcrStandartAnalyzer(), IndexWriter.MaxFieldLength.UNLIMITED);
            try {
                MigrationIndexReader r = new MigrationIndexReader(IndexReader.open((Directory)index.getDirectory()));
                try {
                    writer.addIndexes(new IndexReader[]{r});
                    writer.close();
                    Object var11_16 = null;
                    r.close();
                }
                catch (Throwable throwable) {
                    Object var11_17 = null;
                    r.close();
                    throw throwable;
                }
                Object var13_19 = null;
                writer.close();
            }
            catch (Throwable throwable) {
                Object var13_20 = null;
                writer.close();
                throw throwable;
            }
            Object var15_22 = null;
            migrationDir.close();
        }
        catch (Throwable throwable) {
            Object var15_23 = null;
            migrationDir.close();
            throw throwable;
        }
        directoryManager.delete(index.getName());
        if (!directoryManager.rename(migrationName, index.getName())) {
            throw new IOException("failed to move migrated directory " + migrationDir);
        }
        log.info("Migrated " + index.getName());
    }

    private static class MigrationIndexReader
    extends FilterIndexReader {
        public MigrationIndexReader(IndexReader in) {
            super(in);
        }

        public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
            Document doc = super.document(n, fieldSelector);
            Fieldable[] fields = doc.getFieldables(FieldNames.PROPERTIES);
            if (fields != null) {
                doc.removeFields(FieldNames.PROPERTIES);
                for (int i = 0; i < fields.length; ++i) {
                    String value = fields[i].stringValue();
                    value = value.replace('\uffff', '[');
                    doc.add((Fieldable)new Field(FieldNames.PROPERTIES, value, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
                }
            }
            return doc;
        }

        public TermEnum terms() throws IOException {
            return new MigrationTermEnum(this.in.terms());
        }

        public TermPositions termPositions() throws IOException {
            return new MigrationTermPositions(this.in.termPositions());
        }

        private static class MigrationTermPositions
        extends FilterIndexReader.FilterTermPositions {
            public MigrationTermPositions(TermPositions in) {
                super(in);
            }

            public void seek(Term term) throws IOException {
                if (term.field().equals(FieldNames.PROPERTIES)) {
                    char[] text = term.text().toCharArray();
                    text[term.text().indexOf((int)91)] = 65535;
                    super.seek(term.createTerm(new String(text)));
                } else {
                    super.seek(term);
                }
            }

            public void seek(TermEnum termEnum) throws IOException {
                if (termEnum instanceof MigrationTermEnum) {
                    super.seek(((MigrationTermEnum)termEnum).unwrap());
                } else {
                    super.seek(termEnum);
                }
            }
        }

        private static class MigrationTermEnum
        extends FilterIndexReader.FilterTermEnum {
            public MigrationTermEnum(TermEnum in) {
                super(in);
            }

            public Term term() {
                Term t = super.term();
                if (t == null) {
                    return t;
                }
                if (t.field().equals(FieldNames.PROPERTIES)) {
                    String text = t.text();
                    return t.createTerm(text.replace('\uffff', '['));
                }
                return t;
            }

            TermEnum unwrap() {
                return this.in;
            }
        }
    }
}

