/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.gatein.common.i18n.LocaleFormat;
import org.gatein.common.net.URLTools;
import org.gatein.common.util.ConversionException;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.ActionURL;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.PortletURL;
import org.gatein.pc.api.RenderURL;
import org.gatein.pc.api.StatefulPortletContext;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.state.AccessMode;
import org.gatein.wsrp.WSRPPortletURL;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.registration.LocalizedString;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;
import org.oasis.wsrp.v1.InteractionParams;
import org.oasis.wsrp.v1.MarkupParams;
import org.oasis.wsrp.v1.NamedString;
import org.oasis.wsrp.v1.PropertyDescription;
import org.oasis.wsrp.v1.StateChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRPUtils {
    private static final Map<String, String> JSR168_WSRP_WINDOW_STATES = new HashMap<String, String>(7);
    private static final Map<String, WindowState> WSRP_JSR168_WINDOW_STATES = new HashMap<String, WindowState>(7);
    private static final Map<String, String> JSR168_WSRP_MODES = new HashMap<String, String>(7);
    private static final Map<String, Mode> WSRP_JSR168_MODES = new HashMap<String, Mode>(7);
    private static final String SET_OF_LOCALES = "set of Locales";
    private static final String MODE = "Mode";
    private static final String WSRP_MODE_NAME = "wsrp portlet name";
    private static final String WSRP_WINDOW_STATE_NAME = "wsrp window state name";
    private static final String WINDOW_STATE = "WindowState";
    public static final Set<Mode> DEFAULT_JSR168_MODES;
    public static final Set<WindowState> DEFAULT_JSR168_WINDOWSTATES;
    private static boolean strict;
    private static Logger log;

    public static void setStrict(boolean strict) {
        WSRPUtils.strict = strict;
        log.debug("Using " + (strict ? "strict" : "lenient") + " language code validation mode.");
    }

    private WSRPUtils() {
    }

    public static WindowState getJSR168WindowStateFromWSRPName(String wsrpWindowStateName) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)wsrpWindowStateName, (String)WSRP_WINDOW_STATE_NAME, null);
        WindowState windowState = WSRP_JSR168_WINDOW_STATES.get(wsrpWindowStateName);
        return windowState == null ? WindowState.create((String)wsrpWindowStateName) : windowState;
    }

    public static boolean isDefaultWSRPWindowState(String wsrpWindowStateName) {
        return WSRP_JSR168_WINDOW_STATES.containsKey(wsrpWindowStateName) || "wsrp:solo".equals(wsrpWindowStateName);
    }

    public static String convertJSR168WindowStateNameToWSRPName(String jsr168WindowStateName) {
        if (jsr168WindowStateName == null) {
            return "wsrp:normal";
        }
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)jsr168WindowStateName, (String)WSRP_WINDOW_STATE_NAME, null);
        String wsrpName = JSR168_WSRP_WINDOW_STATES.get(jsr168WindowStateName);
        return wsrpName == null ? jsr168WindowStateName : wsrpName;
    }

    public static String getWSRPNameFromJSR168WindowState(WindowState windowState) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)windowState, (String)WINDOW_STATE);
        return WSRPUtils.convertJSR168WindowStateNameToWSRPName(windowState.toString());
    }

    public static Mode getJSR168PortletModeFromWSRPName(String wsrpPortletModeName) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)wsrpPortletModeName, (String)WSRP_MODE_NAME, null);
        Mode mode = WSRP_JSR168_MODES.get(wsrpPortletModeName);
        return mode == null ? Mode.create((String)wsrpPortletModeName) : mode;
    }

    public static boolean isDefaultWSRPMode(String wsrpPortletModeName) {
        return WSRP_JSR168_MODES.containsKey(wsrpPortletModeName) || "wsrp:preview".equals(wsrpPortletModeName);
    }

    public static String convertJSR168PortletModeNameToWSRPName(String jsr168PortletModeName) {
        if (jsr168PortletModeName == null) {
            return "wsrp:view";
        }
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)jsr168PortletModeName, (String)WSRP_MODE_NAME, null);
        String wsrpName = JSR168_WSRP_MODES.get(jsr168PortletModeName);
        return wsrpName == null ? jsr168PortletModeName : wsrpName;
    }

    public static String getWSRPNameFromJSR168PortletMode(Mode portletMode) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletMode, (String)MODE);
        return WSRPUtils.convertJSR168PortletModeNameToWSRPName(portletMode.toString());
    }

    public static AccessMode getAccessModeFromStateChange(StateChange stateChange) {
        if (StateChange.READ_ONLY.equals((Object)stateChange)) {
            return AccessMode.READ_ONLY;
        }
        if (StateChange.CLONE_BEFORE_WRITE.equals((Object)stateChange)) {
            return AccessMode.CLONE_BEFORE_WRITE;
        }
        if (StateChange.READ_WRITE.equals((Object)stateChange)) {
            return AccessMode.READ_WRITE;
        }
        throw new IllegalArgumentException("Unsupported StateChange: " + stateChange);
    }

    public static StateChange getStateChangeFromAccessMode(AccessMode accessMode) {
        if (AccessMode.READ_ONLY.equals((Object)accessMode)) {
            return StateChange.READ_ONLY;
        }
        if (AccessMode.READ_WRITE.equals((Object)accessMode)) {
            return StateChange.READ_WRITE;
        }
        if (AccessMode.CLONE_BEFORE_WRITE.equals((Object)accessMode)) {
            return StateChange.CLONE_BEFORE_WRITE;
        }
        throw new IllegalArgumentException("Unsupported AccessMode: " + accessMode);
    }

    public static String getWSRPURLTypeFrom(PortletURL url) {
        if (url instanceof WSRPPortletURL) {
            return ((WSRPPortletURL)url).getURLType();
        }
        if (url instanceof RenderURL) {
            return "render";
        }
        if (url instanceof ActionURL) {
            return "blockingAction";
        }
        throw new IllegalArgumentException("Unrecognized URL type.");
    }

    public static String convertRequestAuthTypeToWSRPAuthType(String authType) {
        if (authType == null) {
            return "wsrp:none";
        }
        if ("CLIENT_CERT".equals(authType)) {
            return "wsrp:certificate";
        }
        if ("BASIC".equalsIgnoreCase(authType) || "FORM".equals(authType)) {
            return "wsrp:password";
        }
        return authType;
    }

    public static List<String> convertLocalesToRFC3066LanguageTags(List<Locale> localesOrderedByPreference) {
        ParameterValidation.throwIllegalArgExceptionIfNull(localesOrderedByPreference, (String)SET_OF_LOCALES);
        ArrayList<String> desiredLocales = new ArrayList<String>(localesOrderedByPreference.size());
        for (Locale locale : localesOrderedByPreference) {
            desiredLocales.add(WSRPUtils.toString(locale));
        }
        return desiredLocales;
    }

    public static PortletContext convertToPortalPortletContext(org.oasis.wsrp.v1.PortletContext portletContext) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        String handle = portletContext.getPortletHandle();
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)handle, (String)"portlet handle", (String)"PortletContext");
        byte[] state = portletContext.getPortletState();
        PortletContext context = PortletContext.createPortletContext((String)handle, (byte[])state);
        return context;
    }

    public static PortletContext convertToPortalPortletContext(String portletHandle, byte[] state) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletHandle, (String)"portlet handle", (String)"PortletContext");
        PortletContext context = PortletContext.createPortletContext((String)portletHandle, (byte[])state);
        return context;
    }

    public static org.oasis.wsrp.v1.PortletContext convertToWSRPPortletContext(PortletContext portletContext) {
        StatefulPortletContext context;
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        String id = portletContext.getId();
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"portlet id", (String)"PortletContext");
        org.oasis.wsrp.v1.PortletContext result = WSRPTypeFactory.createPortletContext(id);
        if (portletContext instanceof StatefulPortletContext && PortletStateType.OPAQUE.equals((context = (StatefulPortletContext)portletContext).getType())) {
            result.setPortletState((byte[])context.getState());
        }
        return result;
    }

    public static Locale getLocale(String lang) throws IllegalArgumentException {
        if (lang != null) {
            String possiblyRelaxed = lang;
            if (!strict) {
                possiblyRelaxed = lang.replace('_', '-');
            }
            try {
                return LocaleFormat.RFC3066_LANGUAGE_TAG.getLocale(possiblyRelaxed);
            }
            catch (ConversionException e) {
                if (strict) {
                    throw new IllegalArgumentException(e);
                }
                log.debug("Was given an invalid language: '" + possiblyRelaxed + "'. Since we're using relaxed validation, we will assume " + Locale.ENGLISH + " to avoid crashing!", (Throwable)e);
                return Locale.ENGLISH;
            }
        }
        return Locale.getDefault();
    }

    public static String toString(Locale locale) throws IllegalArgumentException {
        try {
            return LocaleFormat.RFC3066_LANGUAGE_TAG.toString(locale);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toString(MarkupParams params) {
        if (params != null) {
            StringBuffer sb = new StringBuffer("MarkupParams");
            if (params.isSecureClientCommunication()) {
                sb.append("(secure)");
            }
            sb.append("[M=").append(params.getMode()).append("][WS=").append(params.getWindowState()).append("]").append("[NS=").append(params.getNavigationalState()).append("]");
            return sb.toString();
        }
        return null;
    }

    public static String toString(InteractionParams interactionParams) {
        if (interactionParams != null) {
            StringBuffer sb = new StringBuffer("InteractionParams");
            sb.append("[IS=").append(interactionParams.getInteractionState()).append("]").append("[StateChange=").append(interactionParams.getPortletStateChange().value()).append("]");
            List formParams = interactionParams.getFormParameters();
            if (formParams != null) {
                sb.append("\n\tForm params:\n");
                for (NamedString formParam : formParams) {
                    sb.append("\t\t").append(formParam.getName()).append("='").append(formParam.getValue()).append("'\n");
                }
            }
            return sb.toString();
        }
        return null;
    }

    public static RegistrationPropertyDescription convertToRegistrationPropertyDescription(PropertyDescription propertyDescription) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyDescription, (String)"PropertyDescription");
        RegistrationPropertyDescription desc = new RegistrationPropertyDescription(propertyDescription.getName(), propertyDescription.getType());
        desc.setLabel(WSRPUtils.getLocalizedStringOrNull(propertyDescription.getLabel()));
        desc.setHint(WSRPUtils.getLocalizedStringOrNull(propertyDescription.getHint()));
        return desc;
    }

    public static PropertyDescription convertToPropertyDescription(RegistrationPropertyDescription propertyDescription) {
        LocalizedString label;
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyDescription, (String)"RegistrationPropertyDescription");
        PropertyDescription propDesc = WSRPTypeFactory.createPropertyDescription(propertyDescription.getName().toString(), propertyDescription.getType());
        LocalizedString hint = propertyDescription.getHint();
        if (hint != null) {
            propDesc.setHint(WSRPUtils.convertToWSRPLocalizedString(hint));
        }
        if ((label = propertyDescription.getLabel()) != null) {
            propDesc.setLabel(WSRPUtils.convertToWSRPLocalizedString(label));
        }
        return propDesc;
    }

    public static org.oasis.wsrp.v1.LocalizedString convertToWSRPLocalizedString(LocalizedString regLocalizedString) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)regLocalizedString, (String)"LocalizedString");
        return WSRPTypeFactory.createLocalizedString(WSRPUtils.toString(regLocalizedString.getLocale()), regLocalizedString.getResourceName(), regLocalizedString.getValue());
    }

    private static LocalizedString getLocalizedStringOrNull(org.oasis.wsrp.v1.LocalizedString wsrpLocalizedString) {
        if (wsrpLocalizedString == null) {
            return null;
        }
        return WSRPUtils.convertToLocalizedString(wsrpLocalizedString);
    }

    public static LocalizedString convertToLocalizedString(org.oasis.wsrp.v1.LocalizedString wsrpLocalizedString) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)wsrpLocalizedString, (String)"WSRP LocalizedString");
        String lang = wsrpLocalizedString.getLang();
        Locale locale = lang == null ? Locale.getDefault() : WSRPUtils.getLocale(lang);
        LocalizedString localizedString = new LocalizedString(wsrpLocalizedString.getValue(), locale);
        localizedString.setResourceName(wsrpLocalizedString.getResourceName());
        return localizedString;
    }

    public static String getAbsoluteURLFor(String url, boolean checkWSRPToken, String serverAddress) {
        if (checkWSRPToken && url.startsWith("wsrp_rewrite?")) {
            return url;
        }
        if (!URLTools.isNetworkURL((String)url) && url.startsWith("/")) {
            return serverAddress + url;
        }
        return url;
    }

    static {
        strict = true;
        log = LoggerFactory.getLogger(WSRPUtils.class);
        JSR168_WSRP_WINDOW_STATES.put(WindowState.MAXIMIZED.toString(), "wsrp:maximized");
        JSR168_WSRP_WINDOW_STATES.put(WindowState.MINIMIZED.toString(), "wsrp:minimized");
        JSR168_WSRP_WINDOW_STATES.put(WindowState.NORMAL.toString(), "wsrp:normal");
        JSR168_WSRP_MODES.put(Mode.EDIT.toString(), "wsrp:edit");
        JSR168_WSRP_MODES.put(Mode.HELP.toString(), "wsrp:help");
        JSR168_WSRP_MODES.put(Mode.VIEW.toString(), "wsrp:view");
        WSRP_JSR168_WINDOW_STATES.put("wsrp:maximized", WindowState.MAXIMIZED);
        WSRP_JSR168_WINDOW_STATES.put("wsrp:minimized", WindowState.MINIMIZED);
        WSRP_JSR168_WINDOW_STATES.put("wsrp:normal", WindowState.NORMAL);
        WSRP_JSR168_MODES.put("wsrp:edit", Mode.EDIT);
        WSRP_JSR168_MODES.put("wsrp:help", Mode.HELP);
        WSRP_JSR168_MODES.put("wsrp:view", Mode.VIEW);
        DEFAULT_JSR168_MODES = new HashSet<Mode>(WSRP_JSR168_MODES.values());
        DEFAULT_JSR168_WINDOWSTATES = new HashSet<WindowState>(WSRP_JSR168_WINDOW_STATES.values());
    }

    public static class AbsoluteURLReplacementGenerator
    extends URLTools.URLReplacementGenerator {
        private String serverAddress;

        public AbsoluteURLReplacementGenerator(HttpServletRequest request) {
            this.serverAddress = URLTools.getServerAddressFrom((HttpServletRequest)request);
        }

        public String getReplacementFor(int i, URLTools.URLMatch urlMatch) {
            return this.getAbsoluteURLFor(urlMatch.getURLAsString());
        }

        public String getAbsoluteURLFor(String url) {
            return WSRPUtils.getAbsoluteURLFor(url, true, this.serverAddress);
        }
    }
}

