/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.plugins;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import org.jboss.console.manager.interfaces.ManageableResource;
import org.jboss.console.manager.interfaces.TreeNode;
import org.jboss.console.manager.interfaces.TreeNodeMenuEntry;
import org.jboss.console.manager.interfaces.impl.GraphMBeanAttributeAction;
import org.jboss.console.manager.interfaces.impl.HttpLinkTreeAction;
import org.jboss.console.manager.interfaces.impl.SimpleTreeNode;
import org.jboss.console.manager.interfaces.impl.SimpleTreeNodeMenuEntryImpl;
import org.jboss.console.plugins.helpers.AbstractPluginWrapper;
import org.jboss.console.plugins.helpers.jmx.DomainData;
import org.jboss.console.plugins.helpers.jmx.MBeanData;
import org.jboss.console.plugins.helpers.jmx.Server;

public class MBeansLister
extends AbstractPluginWrapper {
    private static HashSet graphableClasses = new HashSet();

    TreeNode createJmxAttributeSubResource(MBeanAttributeInfo attr, ObjectName mbeanName) throws Exception {
        TreeNodeMenuEntry[] entries = null;
        if (graphableClasses.contains(attr.getType())) {
            SimpleTreeNodeMenuEntryImpl entry = new SimpleTreeNodeMenuEntryImpl("graph", new GraphMBeanAttributeAction(mbeanName, attr.getName()));
            SimpleTreeNodeMenuEntryImpl entry2 = new SimpleTreeNodeMenuEntryImpl("create monitor", new HttpLinkTreeAction("/web-console/createThresholdMonitor.jsp?attribute=" + attr.getName() + "&objectName=" + this.encode(mbeanName.toString())));
            SimpleTreeNodeMenuEntryImpl entry3 = new SimpleTreeNodeMenuEntryImpl("create snapshot", new HttpLinkTreeAction("/web-console/createSnapshot.jsp?attribute=" + attr.getName() + "&objectName=" + this.encode(mbeanName.toString())));
            entries = new TreeNodeMenuEntry[]{entry, entry2, entry3};
        } else if (attr.getType().equals("String") || attr.getType().equals("java.lang.String")) {
            SimpleTreeNodeMenuEntryImpl entry = new SimpleTreeNodeMenuEntryImpl("create monitor", new HttpLinkTreeAction("/web-console/createStringThresholdMonitor.jsp?attribute=" + attr.getName() + "&objectName=" + this.encode(mbeanName.toString())));
            entries = new TreeNodeMenuEntry[]{entry};
        }
        return this.createTreeNode(attr.getName(), attr.getDescription(), "images/container.gif", "/jmx-console/HtmlAdaptor?action=inspectMBean&name=" + this.encode("" + mbeanName), entries, null, null);
    }

    TreeNode createJmxMBeanSubResources(MBeanData data) throws Exception {
        String name = "" + data.getObjectName();
        String displayName = data.getName();
        if (displayName == null) {
            int index = name.indexOf(":");
            displayName = index >= 0 ? name.substring(index + 1) : name;
        }
        MBeanAttributeInfo[] attributes = data.getMetaData().getAttributes();
        TreeNode[] attrNodes = new TreeNode[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            attrNodes[i] = this.createJmxAttributeSubResource(attributes[i], data.getObjectName());
        }
        return this.createTreeNode(displayName, name, "images/server.gif", "/jmx-console/HtmlAdaptor?action=inspectMBean&name=" + this.encode(name), null, attrNodes, null);
    }

    TreeNode[] createJmxDomainsSubNodes() throws Exception {
        Iterator mbeans = Server.getDomainData(null);
        TreeNode[] result = null;
        ArrayList<SimpleTreeNode> domains = new ArrayList<SimpleTreeNode>();
        while (mbeans.hasNext()) {
            DomainData domainData = (DomainData)mbeans.next();
            String domainName = domainData.getDomainName();
            MBeanData[] data = domainData.getData();
            TreeNode[] subResources = new TreeNode[data.length];
            for (int d = 0; d < data.length; ++d) {
                subResources[d] = this.createJmxMBeanSubResources(data[d]);
            }
            TreeNodeMenuEntry[] menu = this.createMenus(new String[]{"Number of MBeans: " + data.length, null});
            domains.add(this.createTreeNode(domainName, "MBeans for domain " + domainName, "images/serviceset.gif", null, menu, subResources, null));
        }
        result = domains.size() == 0 ? null : domains.toArray(new TreeNode[domains.size()]);
        return result;
    }

    protected TreeNode getTreeForResource(String profile, ManageableResource resource) {
        try {
            return this.createTreeNode("JMX MBeans", "Display all JMX MBeans", "images/flash.gif", "/jmx-console/HtmlAdaptor?action=displayMBeans", null, this.createJmxDomainsSubNodes(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        graphableClasses.add("java.lang.Integer");
        graphableClasses.add("java.lang.Short");
        graphableClasses.add("java.lang.Double");
        graphableClasses.add("java.lang.Float");
        graphableClasses.add("java.lang.Long");
        graphableClasses.add("int");
        graphableClasses.add("short");
        graphableClasses.add("double");
        graphableClasses.add("float");
        graphableClasses.add("long");
    }
}

