/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Set;
import org.jboss.webbeans.introspector.AnnotatedItem;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.util.Proxies;
import org.jboss.webbeans.util.Reflections;
import org.jboss.webbeans.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotatedItem<T, S>
implements AnnotatedItem<T, S> {
    private String toString;
    private final AnnotationStore annotationStore;
    private final Class<T> rawType;
    private final Type[] actualTypeArguments;
    private final Type type;
    private final Set<? extends Type> flattenedTypes;
    private final boolean proxyable;
    private final boolean _parameterizedType;

    public AbstractAnnotatedItem(AnnotationStore annotatedItemHelper, Class<T> rawType, Type type) {
        this.annotationStore = annotatedItemHelper;
        this.rawType = rawType;
        this.type = type;
        this.actualTypeArguments = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments() : new Type[0];
        this._parameterizedType = Reflections.isParameterizedType(rawType);
        this.flattenedTypes = new Reflections.HierarchyDiscovery(type).getFlattenedTypes();
        this.proxyable = Proxies.isTypesProxyable(this.flattenedTypes);
    }

    public AbstractAnnotatedItem(AnnotationStore annotatedItemHelper) {
        this.annotationStore = annotatedItemHelper;
        this.rawType = null;
        this.type = null;
        this.actualTypeArguments = new Type[0];
        this._parameterizedType = false;
        this.flattenedTypes = null;
        this.proxyable = false;
    }

    @Override
    public AnnotationStore getAnnotationStore() {
        return this.annotationStore;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.getAnnotationStore().getAnnotation(annotationType);
    }

    @Override
    public Set<Annotation> getMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
        return this.getAnnotationStore().getMetaAnnotations(metaAnnotationType);
    }

    @Override
    public Set<Annotation> getDeclaredMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
        return this.getAnnotationStore().getDeclaredMetaAnnotations(metaAnnotationType);
    }

    @Override
    public Annotation[] getMetaAnnotationsAsArray(Class<? extends Annotation> metaAnnotationType) {
        return this.getMetaAnnotations(metaAnnotationType).toArray(new Annotation[0]);
    }

    @Override
    public Set<Annotation> getAnnotationsAsSet() {
        return this.getAnnotationStore().getAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotatedType) {
        return this.getAnnotationStore().isAnnotationPresent(annotatedType);
    }

    public boolean equals(Object other) {
        if (other instanceof AnnotatedItem) {
            AnnotatedItem that = (AnnotatedItem)other;
            return ((Object)this.getAnnotationsAsSet()).equals(that.getAnnotationsAsSet()) && this.getRawType().equals(that.getRawType());
        }
        return false;
    }

    @Override
    public boolean isAssignableFrom(AnnotatedItem<?, ?> that) {
        return this.isAssignableFrom(that.getRawType(), that.getActualTypeArguments());
    }

    @Override
    public boolean isAssignableFrom(Set<? extends Type> types) {
        for (Type type : types) {
            ParameterizedType parameterizedType;
            Class clazz;
            if (!(type instanceof Class ? this.isAssignableFrom(clazz = (Class)type, Reflections.getActualTypeArguments(clazz)) : type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() instanceof Class && this.isAssignableFrom((Class)parameterizedType.getRawType(), parameterizedType.getActualTypeArguments()))) continue;
            return true;
        }
        return false;
    }

    private boolean isAssignableFrom(Class<?> type, Type[] actualTypeArguments) {
        return Types.boxedType(this.getRawType()).isAssignableFrom(Types.boxedType(type)) && Arrays.equals(this.getActualTypeArguments(), actualTypeArguments);
    }

    public int hashCode() {
        return this.getRawType().hashCode();
    }

    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Abstract annotated item " + this.getName();
        return this.toString;
    }

    @Override
    @Deprecated
    public Set<Annotation> getBindings() {
        return this.getAnnotationStore().getBindings();
    }

    @Override
    @Deprecated
    public Annotation[] getBindingsAsArray() {
        return this.getAnnotationStore().getBindingsAsArray();
    }

    @Override
    public boolean isProxyable() {
        return this.proxyable;
    }

    @Override
    public Class<T> getRawType() {
        return this.rawType;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public Set<? extends Type> getFlattenedTypeHierarchy() {
        return this.flattenedTypes;
    }

    public abstract S getDelegate();

    @Override
    public boolean isDeclaredAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotationStore().isDeclaredAnnotationPresent(annotationType);
    }

    @Override
    public boolean isParameterizedType() {
        return this._parameterizedType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface WrappableAnnotatedItem<T, S>
    extends AnnotatedItem<T, S> {
        @Override
        public AnnotationStore getAnnotationStore();
    }
}

