/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.jcr;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.jcr.DataLocationPlugin;
import org.exoplatform.social.jcr.JCRSessionManager;

public class SocialDataLocation {
    private static final Log log = ExoLogger.getLogger(SocialDataLocation.class);
    public static final String REPOSITORY_PARAM = "repository";
    public static final String WORKSPACE_PARAM = "workspace";
    public static final String DEFAULT_REPOSITORY_NAME = "repository";
    public static final String DEFAULT_WORKSPACE_NAME = "portal-system";
    private String socialSpaceRoot;
    private String socialSpaceHome;
    private String socialActivitiesHome;
    private String socialIdentityHome;
    private String socialProfileHome;
    private String socialRelationshipHome;
    private NodeHierarchyCreator creator;
    private String repository;
    private String workspace;
    private JCRSessionManager sessionManager;
    private RepositoryService repositoryService;

    public SocialDataLocation(InitParams params, NodeHierarchyCreator creator, RepositoryService repositoryService) {
        this.creator = creator;
        this.repository = this.getParam(params, "repository", "repository");
        this.workspace = this.getParam(params, WORKSPACE_PARAM, DEFAULT_WORKSPACE_NAME);
        this.repositoryService = repositoryService;
        this.sessionManager = new JCRSessionManager(this.repository, this.workspace, repositoryService);
        this.initPathes();
    }

    private void initPathes() {
        this.socialSpaceRoot = this.getPath("socialSpaceRoot");
        this.socialSpaceHome = this.getPath("socialSpaceHome");
        this.socialActivitiesHome = this.getPath("socialActivitiesHome");
        this.socialIdentityHome = this.getPath("socialIdentityHome");
        this.socialProfileHome = this.getPath("socialProfileHome");
        this.socialRelationshipHome = this.getPath("socialRelationshipHome");
    }

    public void setLocation(DataLocationPlugin plugin) {
        this.repository = plugin.getRepository();
        this.workspace = plugin.getWorkspace();
        this.sessionManager = new JCRSessionManager(this.repository, this.workspace, this.repositoryService);
    }

    protected String getPath(String locationName) {
        if (this.creator == null) {
            return locationName;
        }
        String path = this.creator.getJcrPath(locationName);
        if (path != null) {
            path = path.substring(1);
        }
        return path;
    }

    private String getParam(InitParams params, String name, String defaultValue) {
        String result = null;
        try {
            result = params.getValueParam(name).getValue();
        }
        catch (Exception e) {
            log.warn((Object)("No '" + name + "' value-param. Using default value: " + defaultValue));
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public JCRSessionManager getSessionManager() {
        return this.sessionManager;
    }

    public String getSocialSpaceRoot() {
        return this.socialSpaceRoot;
    }

    public String getSocialSpaceHome() {
        return this.socialSpaceHome;
    }

    public String getSocialActivitiesHome() {
        return this.socialActivitiesHome;
    }

    public String getSocialIdentityHome() {
        return this.socialIdentityHome;
    }

    public String getSocialProfileHome() {
        return this.socialProfileHome;
    }

    public String getSocialRelationshipHome() {
        return this.socialRelationshipHome;
    }

    public static interface Locations {
        public static final String SOCIAL_SPACE_ROOT = "socialSpaceRoot";
        public static final String SOCIAL_SPACE_HOME = "socialSpaceHome";
        public static final String SOCIAL_ACTIVITIES_HOME = "socialActivitiesHome";
        public static final String SOCIAL_IDENTITY_HOME = "socialIdentityHome";
        public static final String SOCIAL_PROFILE_HOME = "socialProfileHome";
        public static final String SOCIAL_RELATIONSHIP_HOME = "socialRelationshipHome";
        public static final String DEFAULT_APPS_LOCATION = "exo:applications";
    }
}

