/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import javax.servlet.http.HttpSessionEvent;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.web.AbstractHttpSessionListener;
import org.exoplatform.portal.application.PortalApplication;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.WebAppController;
import org.exoplatform.webui.application.WebuiApplication;

public class PortalSessionListener
extends AbstractHttpSessionListener {
    protected static Log log = ExoLogger.getLogger((String)"portal:PortalSessionListener");

    protected void onSessionDestroyed(ExoContainer container, HttpSessionEvent event) {
    }

    protected void onSessionCreated(ExoContainer container, HttpSessionEvent event) {
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("Destroy session from '" + container == null ? "unknown" : ((PortalContainer)container).getName() + "' portal"));
            }
            WebAppController controller = (WebAppController)container.getComponentInstanceOfType(WebAppController.class);
            PortalApplication portalApp = (PortalApplication)controller.getApplication("PortalApplication");
            portalApp.getStateManager().expire(event.getSession().getId(), (WebuiApplication)portalApp);
        }
        catch (Exception ex) {
            log.error((Object)"Error while destroying a portal session", (Throwable)ex);
        }
    }

    protected boolean requirePortalEnvironment() {
        return true;
    }
}

