/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.registry;

import org.gatein.pc.api.NoSuchPortletException;
import org.gatein.pc.federation.FederatedPortletInvoker;
import org.gatein.pc.federation.FederatingPortletInvoker;
import org.gatein.pc.federation.NullInvokerHandler;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.consumer.registry.ConsumerRegistry;

public class ActivatingNullInvokerHandler
implements NullInvokerHandler {
    private transient ConsumerRegistry consumerRegistry;

    public FederatedPortletInvoker resolvePortletInvokerFor(String compoundPortletId, String invokerId, FederatingPortletInvoker callingInvoker) throws NoSuchPortletException {
        FederatingPortletInvoker registryInvoker = this.consumerRegistry.getFederatingPortletInvoker();
        if (registryInvoker != callingInvoker) {
            throw new IllegalArgumentException("Trying to use a ConsumerRegistry already linked to a different FederatingPortletInvoker (" + registryInvoker + ") than the specified one (" + callingInvoker + ")");
        }
        WSRPConsumer consumer = this.consumerRegistry.getConsumer(invokerId);
        if (consumer == null) {
            throw new NoSuchPortletException(compoundPortletId);
        }
        this.consumerRegistry.activateConsumerWith(invokerId);
        FederatedPortletInvoker federated = callingInvoker.getFederatedInvoker(invokerId);
        return federated;
    }

    public void setConsumerRegistry(ConsumerRegistry consumerRegistry) {
        this.consumerRegistry = consumerRegistry;
    }
}

