/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.util.HashSet;
import java.util.Set;
import org.jboss.ws.tools.JavaKeywords;
import org.jboss.ws.tools.ToolsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespacePackageMapping {
    private static final NamespacePackageMapping npm = new NamespacePackageMapping();
    private final String[] countryCodesArray = new String[]{"ac", "ad", "ae", "af", "ag", "ai", "al", "am", "an", "ao", "aq", "ar", "as", "at", "au", "aw", "az", "ax", "ba", "bb", "bd", "be", "bf", "bg", "bh", "bi", "bj", "bm", "bn", "bo", "br", "bs", "bt", "bv", "bw", "by", "bz", "ca", "cc", "cd", "cf", "cg", "ch", "ci", "ck", "cl", "cm", "cn", "co", "cr", "cs", "cu", "cv", "cx", "cy", "cz", "de", "dj", "dk", "dm", "do", "dz", "ec", "ee", "eg", "eh", "er", "es", "et", "eu", "fi", "fj", "fk", "fm", "fo", "fr", "ga", "gb", "gd", "ge", "gf", "gg", "gh", "gi", "gl", "gm", "gn", "gp", "gq", "gr", "gs", "gt", "gu", "gw", "gy", "hk", "hm", "hn", "hr", "ht", "hu", "id", "ie", "il", "im", "in", "io", "iq", "ir", "is", "it", "je", "jm", "jo", "jp", "ke", "kg", "kh", "ki", "km", "kn", "kp", "kr", "kw", "ky", "kz", "la", "lb", "lc", "li", "lk", "lr", "ls", "lt", "lu", "lv", "ly", "ma", "mc", "md", "mg", "mh", "mk", "ml", "mm", "mn", "mo", "mp", "mq", "mr", "ms", "mt", "mu", "mv", "mw", "mx", "my", "mz", "na", "nc", "ne", "nf", "ng", "ni", "nl", "no", "np", "nr", "nu", "nz", "om", "pa", "pe", "pf", "pg", "ph", "pk", "pl", "pm", "pn", "pr", "ps", "pt", "pw", "py", "qa", "re", "ro", "ru", "rw", "sa", "sb", "sc", "sd", "se", "sg", "sh", "si", "sj", "sk", "sl", "sm", "sn", "so", "sr", "st", "sv", "sy", "sz", "tc", "td", "tf", "tg", "th", "tj", "tk", "tl", "tm", "tn", "to", "tp", "tr", "tt", "tv", "tw", "tz", "ua", "ug", "uk", "um", "us", "uy", "uz", "va", "vc", "ve", "vg", "vi", "vn", "vu", "wf", "ws", "ye", "yt", "yu", "za", "zm", "zw"};
    private final String[] topLevelDomainsArray = new String[]{"com", "gov", "net", "org", "edu"};
    private final Set<String> topLevelDomains;

    public static String getJavaPackageName(String targetNS) {
        return npm.convertNamespaceToPackage(targetNS);
    }

    private NamespacePackageMapping() {
        int topLevelSize = this.countryCodesArray.length + this.topLevelDomainsArray.length;
        topLevelSize = (int)((double)topLevelSize / 0.75) + 1;
        this.topLevelDomains = new HashSet<String>(topLevelSize);
        this.addAll(this.topLevelDomains, this.countryCodesArray);
        this.addAll(this.topLevelDomains, this.topLevelDomainsArray);
    }

    private void addAll(Set<String> set, String[] data) {
        for (String current : data) {
            set.add(current);
        }
    }

    private String convertNamespaceToPackage(String targetNS) {
        String workingNS = targetNS;
        boolean schemeIsURN = workingNS.startsWith("urn:");
        if (workingNS.startsWith("http://")) {
            workingNS = workingNS.substring(7);
        } else if (workingNS.startsWith("https://")) {
            workingNS = workingNS.substring(8);
        } else if (workingNS.startsWith("urn:")) {
            workingNS = workingNS.substring(4);
        } else {
            throw new IllegalArgumentException("TargetNS should start with http:// / https:// / urn:");
        }
        boolean hasExtension = workingNS.matches("^.*\\/.*\\.((.{2,3})|(html))$");
        if (hasExtension) {
            workingNS = workingNS.substring(0, workingNS.lastIndexOf("."));
        }
        String[] tokens = workingNS.split("[\\/\\:]+");
        if (schemeIsURN) {
            tokens[0] = tokens[0].replace('-', '.');
        }
        String[] packagePrefix = this.convertDomainToPackage(tokens[0]);
        String[] temp = tokens;
        tokens = new String[packagePrefix.length + temp.length - 1];
        System.arraycopy(packagePrefix, 0, tokens, 0, packagePrefix.length);
        System.arraycopy(temp, 1, tokens, packagePrefix.length, temp.length - 1);
        StringBuilder packageName = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            String current = tokens[i];
            current = current.toLowerCase();
            current = this.convertReserved(current);
            current = this.convertStart(current);
            current = ToolsUtils.convertInvalidCharacters(current);
            packageName.append(current);
            if (i >= tokens.length - 1) continue;
            packageName.append(".");
        }
        return packageName.toString();
    }

    private String convertReserved(String component) {
        String result = component;
        if (JavaKeywords.isJavaKeyword(result)) {
            result = result + "_";
        }
        return result;
    }

    private String convertStart(String component) {
        String result = component;
        if (!Character.isJavaIdentifierStart(result.charAt(0))) {
            result = "_" + result;
        }
        return result;
    }

    private String[] convertDomainToPackage(String domain) {
        String[] packge;
        String[] parts = domain.split("\\.");
        if (this.topLevelDomains.contains(parts[parts.length - 1])) {
            packge = parts[0].equals("www") ? new String[parts.length - 1] : new String[parts.length];
            for (int i = 0; i < packge.length; ++i) {
                packge[i] = parts[parts.length - i - 1];
            }
        } else {
            packge = parts;
        }
        return packge;
    }
}

