/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.spi.deployer;

import java.io.Serializable;

public class DeploymentStage
implements Serializable {
    private static final long serialVersionUID = 3302613286025012191L;
    private String name;
    private String after;
    private String before;

    private static String getStageName(DeploymentStage stage, String context) {
        if (stage == null) {
            throw new IllegalArgumentException("Null " + context);
        }
        return stage.getName();
    }

    public DeploymentStage(String name) {
        this(name, (String)null);
    }

    public DeploymentStage(String name, String after) {
        this(name, after, null);
    }

    public DeploymentStage(String name, DeploymentStage after) {
        this(name, DeploymentStage.getStageName(after, "after"), null);
    }

    public DeploymentStage(String name, DeploymentStage after, DeploymentStage before) {
        this(name, DeploymentStage.getStageName(after, "after"), DeploymentStage.getStageName(before, "before"));
    }

    public DeploymentStage(String name, String after, String before) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.name = name;
        this.after = after;
        this.before = before;
    }

    public String getName() {
        return this.name;
    }

    public String getAfter() {
        return this.after;
    }

    public String getBefore() {
        return this.before;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof DeploymentStage)) {
            return false;
        }
        DeploymentStage other = (DeploymentStage)obj;
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

