/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.remoting;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.jboss.mx.remoting.JMXUtil;
import org.jboss.mx.remoting.MBeanServerRegistry;
import org.jboss.mx.remoting.MBeanTransportPreference;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ident.Identity;
import org.jboss.remoting.network.NetworkFilter;
import org.jboss.remoting.network.NetworkInstance;
import org.jboss.remoting.network.NetworkRegistry;
import org.jboss.remoting.network.filter.IdentityFilter;

public class MBeanServerLocator
implements Serializable {
    static final long serialVersionUID = 7632696197699845344L;
    private final Identity identity;
    private boolean autoLocate = true;
    protected transient MBeanServer server;

    public MBeanServerLocator(Identity identity) {
        this.identity = identity;
    }

    public int hashCode() {
        return this.identity.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MBeanServerLocator) {
            return this.identity.equals((Object)((MBeanServerLocator)obj).identity);
        }
        return false;
    }

    public String toString() {
        return "MBeanServerLocator [" + this.identity.getJMXId() + "]";
    }

    public String getServerId() {
        return this.identity.getJMXId();
    }

    public final Identity getIdentity() {
        return this.identity;
    }

    public String getInstanceId() {
        return this.identity.getInstanceId();
    }

    public InetAddress getAddress() {
        return this.identity.getAddress();
    }

    public MBeanServer getMBeanServer() {
        if (this.server == null) {
            this.server = this.resolveServer();
        }
        if (this.server == null) {
            throw new ConnectionFailedException("Couldn't find server at: " + this.identity);
        }
        return this.server;
    }

    protected MBeanServer resolveServer() throws ConnectionFailedException {
        NetworkInstance[] ni;
        ArrayList<MBeanServer> list;
        MBeanServer server = null;
        String id = System.getProperty("jboss.identity");
        if (id != null && id.equals(this.identity.getInstanceId()) && !(list = MBeanServerFactory.findMBeanServer(null)).isEmpty()) {
            for (MBeanServer s : list) {
                try {
                    if (!JMXUtil.getServerId(s).equals(this.identity.getJMXId())) continue;
                    return s;
                }
                catch (Exception ex) {
                }
            }
        }
        if ((server = MBeanServerRegistry.getMBeanServerFor(this.getServerId())) == null && (ni = NetworkRegistry.getInstance().queryServers((NetworkFilter)new IdentityFilter(this.identity))) != null && ni.length > 0) {
            InvokerLocator[] locators = ni[0].getLocators();
            String jmxId = ni[0].getIdentity().getJMXId();
            ArrayList<MBeanServer> list2 = MBeanServerFactory.findMBeanServer(jmxId);
            if (list2 != null && !list2.isEmpty()) {
                return list2.get(0);
            }
            try {
                server = MBeanTransportPreference.getServerByTransport(this.identity, locators);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return server == null ? null : server;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.autoLocate) {
            this.resolveServer();
        }
    }

    public void setAutoLocate(boolean autoLocate) {
        this.autoLocate = autoLocate;
    }
}

