/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.io.Serializable;
import org.hibernate.HibernateException;

public class ConnectionReleaseMode
implements Serializable {
    public static final ConnectionReleaseMode AFTER_STATEMENT = new ConnectionReleaseMode("after_statement");
    public static final ConnectionReleaseMode AFTER_TRANSACTION = new ConnectionReleaseMode("after_transaction");
    public static final ConnectionReleaseMode ON_CLOSE = new ConnectionReleaseMode("on_close");
    private String name;

    private ConnectionReleaseMode(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static ConnectionReleaseMode parse(String modeName) throws HibernateException {
        if (ConnectionReleaseMode.AFTER_STATEMENT.name.equals(modeName)) {
            return AFTER_STATEMENT;
        }
        if (ConnectionReleaseMode.AFTER_TRANSACTION.name.equals(modeName)) {
            return AFTER_TRANSACTION;
        }
        if (ConnectionReleaseMode.ON_CLOSE.name.equals(modeName)) {
            return ON_CLOSE;
        }
        throw new HibernateException("could not determine appropriate connection release mode [" + modeName + "]");
    }

    private Object readResolve() {
        return ConnectionReleaseMode.parse(this.name);
    }
}

