/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.Service;
import com.arjuna.ats.internal.arjuna.recovery.Connection;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class Listener
extends Thread {
    private ServerSocket _listener_socket;
    private int _listener_port;
    private boolean _stop_listener = false;
    private int _listener_socket_timeout_in_msecs = 1500;
    private Service _listener_service;
    private static boolean setTimeout = false;

    public Listener(int port, Service service) throws IOException {
        super("Listener:" + port);
        this._listener_port = port;
        this._listener_service = service;
        this._listener_socket = new ServerSocket(this._listener_port);
        if (setTimeout) {
            this._listener_socket.setSoTimeout(this._listener_socket_timeout_in_msecs);
        }
    }

    public Listener(ServerSocket serverSocket, Service service) throws IOException {
        super("Listener:" + serverSocket.getLocalPort());
        this._listener_port = serverSocket.getLocalPort();
        this._listener_service = service;
        this._listener_socket = serverSocket;
        if (setTimeout) {
            this._listener_socket.setSoTimeout(this._listener_socket_timeout_in_msecs);
        }
    }

    public void finalize() {
        this.stopListener();
        try {
            this._listener_socket.close();
        }
        catch (IOException ex) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.Listener_1");
        }
    }

    public void run() {
        while (!this._stop_listener) {
            try {
                Socket conn = this._listener_socket.accept();
                Connection new_conn = new Connection(conn, this._listener_service);
                if (tsLogger.arjLogger.debugAllowed()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "Connected to " + conn.getInetAddress().getHostAddress() + " on port " + conn.getPort() + " on listener port " + conn.getLocalPort() + " for service " + this._listener_service.getClass().getName());
                }
                new_conn.start();
            }
            catch (InterruptedIOException ex) {
            }
            catch (SocketException ex) {
                if (!tsLogger.arjLogger.debugAllowed()) continue;
                tsLogger.arjLogger.debug(16L, 4L, 2048L, "Recovery listener existing " + this._listener_service.getClass().getName());
            }
            catch (IOException ex) {
                if (!tsLogger.arjLoggerI18N.debugAllowed()) continue;
                tsLogger.arjLoggerI18N.debug("com.arjuna.ats.internal.arjuna.recovery.Listener_2 " + ex);
            }
            catch (Exception exception) {}
        }
    }

    public void stopListener() {
        this._stop_listener = true;
        this.interrupt();
        try {
            this._listener_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        String timeoutSocket = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.internal.arjuna.recovery.listener.timeoutsocket", "NO");
        if (timeoutSocket.equals("YES")) {
            setTimeout = true;
        }
    }
}

