/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xjavadoc.AbstractProgramElement;
import xjavadoc.SourceClass;
import xjavadoc.TagValidationException;
import xjavadoc.XDoc;
import xjavadoc.XJavaDoc;
import xjavadoc.XProgramElement;
import xjavadoc.XTag;
import xjavadoc.event.XTagEvent;
import xjavadoc.event.XTagListener;
import xjavadoc.filesystem.AbstractFile;

public class DefaultXTag
implements XTag {
    public static int instanceCount = 0;
    private String _name;
    private String _value;
    private Map _attributes;
    private List _attributeNames = null;
    private boolean _isParsed = false;
    private int _hash = Integer.MIN_VALUE;
    private boolean _isDirty = false;
    private XDoc _doc;
    private Set _tagListeners;
    private int _lineNumber;
    private XJavaDoc _xJavaDoc;

    public DefaultXTag() {
        ++instanceCount;
    }

    private static int skipWhitespace(String s, int i) {
        while (i < s.length() && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        return i;
    }

    public final XDoc getDoc() {
        return this._doc;
    }

    public final String getAttributeValue(String attributeName) {
        if (!this._isParsed) {
            this.parse();
        }
        return this._attributes == null ? null : (String)this._attributes.get(attributeName);
    }

    public final Collection getAttributeNames() {
        if (!this._isParsed) {
            this.parse();
        }
        return this._attributeNames == null ? AbstractProgramElement.EMPTY_LIST : this._attributeNames;
    }

    public final String getName() {
        if (!this._isParsed) {
            this.parse();
        }
        return this._name;
    }

    public final String getValue() {
        return this._value;
    }

    public final int getLineNumber() {
        return this._lineNumber;
    }

    public final String getInfo() {
        XProgramElement pe = this.getDoc().getOwner();
        AbstractFile file = XJavaDoc.getSourceFileFor(pe);
        return "@" + this.getName() + " at " + file.getPath() + ":" + this.getLineNumber();
    }

    public final void setAttribute(String attributeName, String attributeValue) {
        if (!this._isParsed) {
            this.parse();
        }
        this.setAttribute_Impl(attributeName, attributeValue);
        this.fireTagChanged();
        this._isDirty = true;
        this._value = null;
    }

    public final void addTagListener(XTagListener tagListener) {
        this.ensureTagListenersInitialised();
        this._tagListeners.add(tagListener);
    }

    public final void removeTagListener(XTagListener tagListener) {
        this.ensureTagListenersInitialised();
        this._tagListeners.remove(tagListener);
    }

    public final String removeAttribute(String attributeName) {
        if (!this._isParsed) {
            this.parse();
        }
        this._isDirty = true;
        this.resetValue();
        this.fireTagChanged();
        String removed = (String)this._attributes.remove(attributeName);
        if (removed != null) {
            this._attributeNames.remove(attributeName);
            this._value = null;
        }
        return removed;
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    public final int hashCode() {
        if (this._hash == Integer.MIN_VALUE) {
            this._hash += this._name.hashCode();
        }
        return this._hash;
    }

    public void validate() throws TagValidationException {
    }

    protected final void fail(String message) throws TagValidationException {
        throw new TagValidationException(message, this);
    }

    final void init(String name, String value, XDoc doc, int lineNumber) {
        this._name = name;
        this._doc = doc;
        this._lineNumber = lineNumber;
        this._isDirty = false;
        this._value = value;
        if (doc != null) {
            XProgramElement owner = doc.getOwner();
            this._xJavaDoc = owner.getXJavaDoc();
            this._value = this._xJavaDoc.dereferenceProperties(value);
            if (owner != null) {
                SourceClass sourceClass = owner.getContainingClass() != null ? (SourceClass)owner.getContainingClass() : (SourceClass)owner;
                sourceClass.addTagForValidation(this);
            }
        }
    }

    private final void setAttribute_Impl(String attributeName, String attributeValue) {
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName can't be null!");
        }
        if (this._attributes == null) {
            this._attributes = new HashMap();
            this._attributeNames = new LinkedList();
        }
        if (!this._attributes.containsKey(attributeName)) {
            this._attributeNames.add(attributeName);
        }
        if (this._xJavaDoc != null) {
            attributeValue = this._xJavaDoc.dereferenceProperties(attributeValue);
        }
        this._attributes.put(attributeName, attributeValue);
        this.resetValue();
    }

    private final void ensureTagListenersInitialised() {
        if (this._tagListeners == null) {
            this._tagListeners = new HashSet();
        }
    }

    private void fireTagChanged() {
        if (this._tagListeners == null) {
            return;
        }
        Iterator i = this._tagListeners.iterator();
        while (i.hasNext()) {
            XTagListener tagListener = (XTagListener)i.next();
            tagListener.tagChanged(new XTagEvent(this));
        }
    }

    private final void parse() {
        if (!this._isParsed) {
            String attributeName = null;
            StringBuffer attributeValue = new StringBuffer();
            int end = 0;
            String value = this.getValue();
            for (int i = 0; i < value.length() && (i = DefaultXTag.skipWhitespace(value, i)) < value.length(); ++i) {
                for (end = i; end < value.length() && value.charAt(end) != '=' && !Character.isWhitespace(value.charAt(end)); ++end) {
                }
                attributeName = value.substring(i, end);
                i = DefaultXTag.skipWhitespace(value, end);
                if (i < value.length() && value.charAt(i) == '=') {
                    ++i;
                }
                if ((i = DefaultXTag.skipWhitespace(value, i)) < value.length() && value.charAt(i) == '\"') {
                    ++i;
                } else {
                    this._isParsed = true;
                    return;
                }
                while (i < value.length()) {
                    if (value.charAt(i) == '\"') {
                        if (value.charAt(i - 1) != '\\') {
                            if (i + 1 >= value.length() || Character.isWhitespace(value.charAt(i + 1))) break;
                            this._isParsed = true;
                            return;
                        }
                        attributeValue.delete(attributeValue.length() - 1, attributeValue.length());
                    }
                    attributeValue.append(value.charAt(i));
                    ++i;
                }
                if (i < value.length() && value.charAt(i) == '\"') {
                } else {
                    this._isParsed = true;
                    return;
                }
                this.setAttribute_Impl(attributeName, attributeValue.toString());
                attributeName = null;
                attributeValue.delete(0, attributeValue.length());
            }
            this._isParsed = true;
        }
    }

    private final void resetValue() {
        StringBuffer sb = new StringBuffer();
        if (this._attributeNames != null) {
            Iterator attributeNames = this._attributeNames.iterator();
            while (attributeNames.hasNext()) {
                String attributeName = (String)attributeNames.next();
                String attributeValue = (String)this._attributes.get(attributeName);
                sb.append(attributeName);
                sb.append("=\"");
                sb.append(attributeValue.trim());
                sb.append("\" ");
            }
        }
        this._value = sb.toString().trim();
    }
}

