/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.dependency;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.deployers.vfs.plugins.dependency.DependenciesMetaData;
import org.jboss.deployers.vfs.plugins.dependency.DependencyItemMetaData;
import org.jboss.deployers.vfs.plugins.dependency.DeploymentDependencies;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentDependenciesImpl
implements DeploymentDependencies {
    private Object name;
    private DependenciesMetaData dmd;
    private Set<DependencyItem> dependencies;

    public DeploymentDependenciesImpl(Object name, DependenciesMetaData dmd) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (dmd == null) {
            throw new IllegalArgumentException("Null dmd");
        }
        this.name = name;
        this.dmd = dmd;
    }

    protected DependencyItem createDependencyItem(DependencyItemMetaData dimd) {
        return new AbstractDependencyItem(this.name, dimd.getValue(), dimd.getWhenRequired(), dimd.getDependentState());
    }

    @Override
    public Set<DependencyItem> getDependencies() {
        if (this.dependencies == null) {
            List<DependencyItemMetaData> dimds = this.dmd.getItems();
            if (dimds != null && !dimds.isEmpty()) {
                this.dependencies = new HashSet<DependencyItem>();
                for (DependencyItemMetaData dimd : dimds) {
                    this.dependencies.add(this.createDependencyItem(dimd));
                }
            } else {
                this.dependencies = Collections.emptySet();
            }
        }
        return this.dependencies;
    }
}

