/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.element;

import org.jboss.ws.extensions.security.element.BinarySecurityToken;
import org.jboss.ws.extensions.security.element.DirectReference;
import org.jboss.ws.extensions.security.element.KeyIdentifier;
import org.jboss.ws.extensions.security.element.SecurityElement;
import org.jboss.ws.extensions.security.element.X509IssuerSerial;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Reference
implements SecurityElement {
    public static final String DIRECT_REFERENCE = "directReference";
    public static final String KEY_IDENTIFIER = "keyIdentifier";
    public static final String X509ISSUER_SERIAL = "x509IssuerSerial";

    public static Reference getReference(Element element) throws WSSecurityException {
        String name = element.getLocalName();
        if ("Reference".equals(name)) {
            return new DirectReference(element);
        }
        if ("KeyIdentifier".equals(name)) {
            return new KeyIdentifier(element);
        }
        if ("X509Data".equals(name)) {
            return new X509IssuerSerial(element);
        }
        throw new WSSecurityException("Unkown reference element: " + name);
    }

    public static Reference getReference(String tokenRefType, Document message, BinarySecurityToken token) throws WSSecurityException {
        if (tokenRefType == null || DIRECT_REFERENCE.equals(tokenRefType)) {
            return new DirectReference(message, token);
        }
        if (KEY_IDENTIFIER.equals(tokenRefType)) {
            return new KeyIdentifier(message, token);
        }
        if (X509ISSUER_SERIAL.equals(tokenRefType)) {
            return new X509IssuerSerial(message, token);
        }
        throw new WSSecurityException("Unkown token reference type: " + tokenRefType);
    }
}

