/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.server;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.logging.Logger;
import org.jboss.ws.extensions.addressing.AddressingClientUtil;
import org.jboss.ws.extensions.wsrm.RMFault;
import org.jboss.ws.extensions.wsrm.RMFaultCode;
import org.jboss.ws.extensions.wsrm.RMSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMServerSequence
implements RMSequence {
    private static final Logger logger = Logger.getLogger(RMServerSequence.class);
    private String sequenceId;
    private String inboundId;
    private String outboundId;
    private long creationTime;
    private long duration;
    private Set<Long> acknowledgedOutboundMessages = new TreeSet<Long>();
    private Set<Long> receivedInboundMessages = new TreeSet<Long>();
    private boolean closed;
    private boolean terminated;
    private boolean inboundMessageAckRequested;
    private long messageNumber;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMServerSequence(File serializedSequence) throws IOException {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(serializedSequence));
            this.sequenceId = serializedSequence.getName();
            this.inboundId = ois.readUTF();
            this.outboundId = ois.readUTF();
            this.closed = ois.readBoolean();
            this.terminated = ois.readBoolean();
            this.creationTime = ois.readLong();
            this.duration = ois.readLong();
            this.messageNumber = ois.readLong();
            int countOfOutboundMessages = ois.readInt();
            for (int i = 0; i < countOfOutboundMessages; ++i) {
                this.acknowledgedOutboundMessages.add(ois.readLong());
            }
            int countOfInboundMessages = ois.readInt();
            for (int i = 0; i < countOfInboundMessages; ++i) {
                this.receivedInboundMessages.add(ois.readLong());
            }
        }
        finally {
            ois.close();
        }
    }

    public RMServerSequence() {
        this.sequenceId = "seq-" + System.currentTimeMillis() + "-" + System.identityHashCode(this);
        this.inboundId = AddressingClientUtil.generateMessageID().toString();
        this.outboundId = AddressingClientUtil.generateMessageID().toString();
        this.creationTime = System.currentTimeMillis();
        this.duration = 600000L;
    }

    public String getId() {
        return this.sequenceId;
    }

    @Override
    public String getInboundId() {
        return this.inboundId;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public String getAcksTo() {
        return null;
    }

    @Override
    public String getOutboundId() {
        return this.outboundId;
    }

    public final void addReceivedInboundMessage(long messageId) {
        if (this.closed) {
            HashMap<String, Object> detailsMap = new HashMap<String, Object>(2);
            detailsMap.put("identifier", this.inboundId);
            throw new RMFault(RMFaultCode.SEQUENCE_CLOSED, detailsMap);
        }
        if (messageId == Long.MAX_VALUE) {
            HashMap<String, Object> detailsMap = new HashMap<String, Object>(3);
            detailsMap.put("identifier", this.inboundId);
            detailsMap.put("maxMessageNumber", this.messageNumber);
            this.terminate();
            throw new RMFault(RMFaultCode.MESSAGE_NUMBER_ROLLOVER, detailsMap);
        }
        this.receivedInboundMessages.add(messageId);
        logger.debug((Object)("Inbound Sequence: " + this.inboundId + ", received message no. " + messageId));
    }

    public final void addReceivedOutboundMessage(long messageId) {
        this.acknowledgedOutboundMessages.add(messageId);
        logger.debug((Object)("Outbound Sequence: " + this.outboundId + ", message no. " + messageId + " acknowledged by server"));
    }

    public final void ackRequested(boolean requested) {
        this.inboundMessageAckRequested = requested;
        logger.debug((Object)("Inbound Sequence: " + this.inboundId + ", ack requested. Messages in the queue: " + this.receivedInboundMessages));
    }

    @Override
    public final long newMessageNumber() {
        if (this.messageNumber == Long.MAX_VALUE) {
            this.terminate();
            HashMap<String, Object> detailsMap = new HashMap<String, Object>(3);
            detailsMap.put("identifier", this.outboundId);
            detailsMap.put("maxMessageNumber", this.messageNumber);
            throw new RMFault(RMFaultCode.MESSAGE_NUMBER_ROLLOVER, detailsMap);
        }
        return ++this.messageNumber;
    }

    @Override
    public final long getLastMessageNumber() {
        return this.messageNumber;
    }

    public final boolean isAckRequested() {
        return this.inboundMessageAckRequested;
    }

    @Override
    public Set<Long> getReceivedInboundMessages() {
        return this.receivedInboundMessages;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void terminate() {
        this.terminated = true;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeUTF(this.inboundId);
        oos.writeUTF(this.outboundId);
        oos.writeBoolean(this.closed);
        oos.writeBoolean(this.terminated);
        oos.writeLong(this.creationTime);
        oos.writeLong(this.duration);
        oos.writeLong(this.messageNumber);
        oos.writeInt(this.acknowledgedOutboundMessages.size());
        Iterator<Long> i = this.acknowledgedOutboundMessages.iterator();
        while (i.hasNext()) {
            oos.writeLong(i.next());
        }
        oos.writeInt(this.receivedInboundMessages.size());
        i = this.receivedInboundMessages.iterator();
        while (i.hasNext()) {
            oos.writeLong(i.next());
        }
        oos.close();
        return baos.toByteArray();
    }

    public String toString() {
        return this.sequenceId + "[" + this.inboundId + " - " + this.outboundId + "]";
    }
}

