/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import org.jboss.mx.util.RunnableScheduler;
import org.jboss.util.timeout.Timeout;

public abstract class SchedulableRunnable
implements Runnable {
    private SynchronizedLong nextRun = new SynchronizedLong(0L);
    private RunnableScheduler scheduler;
    private boolean running;
    private boolean reschedule;
    private Timeout timeout;

    public long getNextRun() {
        return this.nextRun.get();
    }

    public synchronized void setNextRun(long nextRun) {
        if (this.timeout != null) {
            this.timeout.cancel();
        }
        this.nextRun.set(nextRun);
        if (!this.running && this.scheduler != null) {
            this.timeout = this.scheduler.add(this);
        } else {
            this.reschedule = true;
        }
    }

    public synchronized RunnableScheduler setScheduler(RunnableScheduler scheduler) {
        if (this.scheduler == scheduler) {
            return this.scheduler;
        }
        RunnableScheduler result = this.scheduler;
        if (this.timeout != null) {
            this.timeout.cancel();
        }
        this.scheduler = scheduler;
        if (scheduler == null) {
            this.reschedule = false;
        } else if (!this.running) {
            this.timeout = scheduler.add(this);
        } else {
            this.reschedule = true;
        }
        return result;
    }

    public abstract void doRun();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        this.startRun();
        try {
            this.doRun();
        }
        finally {
            this.endRun();
        }
    }

    private synchronized void startRun() {
        this.running = true;
    }

    private synchronized void endRun() {
        this.running = false;
        if (this.reschedule) {
            this.timeout = this.scheduler.add(this);
        }
        this.reschedule = false;
    }
}

