/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.injection.finders;

import java.lang.reflect.Method;
import java.util.Collection;
import org.jboss.wsf.common.injection.InjectionException;
import org.jboss.wsf.common.injection.finders.ReflectionUtils;
import org.jboss.wsf.common.reflection.MethodFinder;
import org.jboss.wsf.spi.metadata.injection.InjectionMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InjectionMethodFinder
extends MethodFinder {
    private final InjectionMetaData injectionMD;

    public InjectionMethodFinder(InjectionMetaData injectionMD) {
        if (injectionMD == null) {
            throw new IllegalArgumentException("Injection metadata cannot be null");
        }
        this.injectionMD = injectionMD;
    }

    @Override
    public boolean matches(Method method) {
        if (method.getName().equals(this.injectionMD.getTargetName())) {
            if (this.injectionMD.getValueClass() != null) {
                if (method.getParameterTypes().length == 1) {
                    Class expectedClass = this.injectionMD.getValueClass();
                    Class<?> parameterClass = method.getParameterTypes()[0];
                    return expectedClass.equals(parameterClass);
                }
            } else if (method.getParameterTypes().length == 1) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void validate(Collection<Method> methods) {
        super.validate(methods);
        if (methods.size() > 2) {
            throw new InjectionException("More than one method found matching the criteria: " + this.injectionMD);
        }
    }

    @Override
    public void validate(Method method) {
        super.validate(method);
        ReflectionUtils.assertVoidReturnType(method);
        ReflectionUtils.assertOneParameter(method);
        ReflectionUtils.assertNoPrimitiveParameters(method);
        ReflectionUtils.assertValidSetterName(method);
        ReflectionUtils.assertNoCheckedExceptionsAreThrown(method);
        ReflectionUtils.assertNotStatic(method);
    }
}

