/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.nekohtml;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.Reader;
import java.io.StringReader;
import org.apache.shindig.gadgets.parse.nekohtml.NekoSimplifiedHtmlParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.HTMLScanner;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;

@Singleton
public class SocialMarkupHtmlParser
extends NekoSimplifiedHtmlParser {
    @Inject
    public SocialMarkupHtmlParser(DOMImplementation documentProvider) {
        super(documentProvider);
    }

    protected boolean isElementImportant(QName name) {
        return true;
    }

    protected HTMLConfiguration newConfiguration() {
        HTMLConfiguration config = super.newConfiguration();
        config.setFeature("http://xml.org/sax/features/namespaces", true);
        return config;
    }

    protected NekoSimplifiedHtmlParser.DocumentHandler newDocumentHandler(String source, HTMLScanner scanner) {
        return new SocialMarkupDocumentHandler(source, scanner);
    }

    private class SocialMarkupDocumentHandler
    extends NekoSimplifiedHtmlParser.DocumentHandler {
        private StringBuilder scriptContent;
        private boolean inScript;
        private final HTMLScanner scanner;

        public SocialMarkupDocumentHandler(String content, HTMLScanner scanner) {
            super(SocialMarkupHtmlParser.this, content);
            this.inScript = false;
            this.scanner = scanner;
        }

        public void characters(XMLString text, Augmentations augs) throws XNIException {
            if (this.inScript) {
                this.scriptContent.append(text.ch, text.offset, text.length);
            } else {
                super.characters(text, augs);
            }
        }

        public void endElement(QName name, Augmentations augs) throws XNIException {
            if (this.inScript) {
                XMLInputSource scriptSource = new XMLInputSource(null, null, null);
                scriptSource.setCharacterStream((Reader)new StringReader(this.scriptContent.toString()));
                this.scriptContent.setLength(0);
                this.inScript = false;
                this.scanner.evaluateInputSource(scriptSource);
            }
            super.endElement(name, augs);
        }

        public void comment(XMLString text, Augmentations augs) throws XNIException {
            this.flushTextBuffer();
            Comment comment = this.getDocument().createComment(new String(text.ch, text.offset, text.length));
            this.appendChild(comment);
        }

        public void startElement(QName name, XMLAttributes xmlAttributes, Augmentations augs) throws XNIException {
            String type;
            if (name.rawname.toLowerCase().equals("script") && ("text/os-data".equals(type = xmlAttributes.getValue("type")) || "text/os-template".equals(type))) {
                if (this.inScript) {
                    throw new XNIException("Nested OpenSocial script elements");
                }
                this.inScript = true;
                if (this.scriptContent == null) {
                    this.scriptContent = new StringBuilder();
                }
            }
            super.startElement(name, xmlAttributes, augs);
        }
    }
}

