/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.state.producer;

import java.util.Map;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.pc.portlet.state.InvalidStateIdException;
import org.gatein.pc.portlet.state.NoSuchStateException;
import org.gatein.pc.portlet.state.SimplePropertyMap;
import org.gatein.pc.portlet.state.producer.PortletState;
import org.gatein.pc.portlet.state.producer.PortletStateContext;
import org.gatein.pc.portlet.state.producer.PortletStatePersistenceManager;

public abstract class AbstractPortletStatePersistenceManager
implements PortletStatePersistenceManager {
    public PortletStateContext loadState(String stateId) throws IllegalArgumentException, NoSuchStateException, InvalidStateIdException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)stateId, (String)"state id", null);
        PortletStateContext context = this.getStateContext(stateId);
        if (context == null) {
            throw new NoSuchStateException(stateId);
        }
        return context;
    }

    protected PortletState getState(String stateId) throws NoSuchStateException, InvalidStateIdException {
        PortletStateContext context = this.loadState(stateId);
        return context.getState();
    }

    public String createState(String portletId, PropertyMap propertyMap) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletId, (String)"portlet id", null);
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyMap, (String)"property map");
        return this.createStateContext(portletId, propertyMap);
    }

    public String cloneState(String stateId, PropertyMap propertyMap) throws NoSuchStateException, InvalidStateIdException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyMap, (String)"property map");
        PortletState stateContext = this.getState(stateId);
        return this.createState(stateContext.getPortletId(), propertyMap);
    }

    public String cloneState(String stateId) throws IllegalArgumentException, NoSuchStateException, InvalidStateIdException {
        PortletState state = this.getState(stateId);
        return this.createState(state.getPortletId(), new SimplePropertyMap(state.getProperties()));
    }

    public void updateState(String stateId, PropertyMap propertyMap) throws NoSuchStateException, InvalidStateIdException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyMap, (String)"property map");
        PortletStateContext ctx = this.loadState(stateId);
        PortletState state = ctx.getState();
        PropertyMap props = state.getProperties();
        props.clear();
        props.putAll((Map)propertyMap);
        this.updateStateContext(ctx);
    }

    public void destroyState(String stateId) throws InvalidStateIdException, NoSuchStateException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)stateId, (String)"state id", null);
        if (this.destroyStateContext(stateId) == null) {
            throw new NoSuchStateException(stateId);
        }
    }

    protected abstract PortletStateContext getStateContext(String var1) throws InvalidStateIdException;

    protected abstract String createStateContext(String var1, PropertyMap var2);

    protected abstract PortletStateContext destroyStateContext(String var1) throws InvalidStateIdException;

    protected abstract void updateStateContext(PortletStateContext var1);
}

