/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.measurement.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.composite.MeasurementNumericValueAndUnits;
import org.rhq.core.domain.measurement.util.MeasurementConversionException;

public class MeasurementConverter {
    private static final int MAX_PRECISION_DIGITS = 4;
    private static final String NULL_OR_NAN_FORMATTED_VALUE = "--no data available--";
    private static final String NUMBER_OPTIONAL_UNIT_PATTERN_STRING = "([\\+\\-]?[0-9\\.\\,]{1,})([\\%a-z]*)";
    private static final Pattern NUMBER_OPTIONAL_UNIT_PATTERN = Pattern.compile("([\\+\\-]?[0-9\\.\\,]{1,})([\\%a-z]*)", 2);

    private static NumberFormat getDefaultNumberFormat() {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumFractionDigits(1);
        nf.setMaximumFractionDigits(1);
        return nf;
    }

    public static MeasurementNumericValueAndUnits parse(String input, MeasurementUnits targetUnits) throws MeasurementConversionException {
        MeasurementUnits fromUnits;
        Matcher matcher = NUMBER_OPTIONAL_UNIT_PATTERN.matcher(input = input.replaceAll("\\s", ""));
        if (!matcher.matches()) {
            throw new MeasurementConversionException("The passed input '" + input + "' could not be parsed correctly " + "by the regular expression " + NUMBER_OPTIONAL_UNIT_PATTERN_STRING);
        }
        String magnitude = matcher.group(1);
        String units = matcher.group(2);
        if (units.equals("")) {
            fromUnits = targetUnits;
        } else {
            fromUnits = MeasurementUnits.getUsingDisplayUnits(units, targetUnits.getFamily());
            if (fromUnits == null || !fromUnits.isComparableTo(targetUnits)) {
                throw new MeasurementConversionException("The units in '" + input + "' were not valid, " + "expected '" + (Object)((Object)targetUnits.getFamily()) + "' units " + "received '" + units + "' units");
            }
        }
        try {
            Double scaledMagnitude;
            if (magnitude.startsWith("+")) {
                magnitude = magnitude.substring(1);
            }
            Number convertedMagnitude = DecimalFormat.getInstance().parse(magnitude);
            if (MeasurementUnits.Family.RELATIVE == targetUnits.getFamily()) {
                scaledMagnitude = MeasurementUnits.scaleDown(convertedMagnitude.doubleValue(), targetUnits);
            } else {
                MeasurementNumericValueAndUnits valueAndUnits = new MeasurementNumericValueAndUnits(convertedMagnitude.doubleValue(), fromUnits);
                scaledMagnitude = MeasurementConverter.scale(valueAndUnits, targetUnits);
            }
            return new MeasurementNumericValueAndUnits(scaledMagnitude, targetUnits);
        }
        catch (ParseException pe) {
            throw new MeasurementConversionException("The magnitude in '" + input + "' did not parse correctly " + "as a valid, localized, stringified number ");
        }
    }

    public static MeasurementNumericValueAndUnits parse(String input, MeasurementSchedule targetSchedule) throws MeasurementConversionException {
        MeasurementUnits targetUnits = targetSchedule.getDefinition().getUnits();
        return MeasurementConverter.parse(input, targetUnits);
    }

    public static Double scale(MeasurementNumericValueAndUnits origin, MeasurementUnits targetUnits) throws MeasurementConversionException {
        MeasurementUnits originUnits = origin.getUnits();
        Double originValue = origin.getValue();
        return originValue * MeasurementUnits.calculateOffset(originUnits, targetUnits);
    }

    public static Double scale(Double origin, MeasurementUnits targetUnits) throws MeasurementConversionException {
        boolean wasNegative = false;
        if (origin < 0.0) {
            wasNegative = true;
            origin = -origin.doubleValue();
        }
        MeasurementUnits baseUnit = targetUnits.getBaseUnits();
        MeasurementNumericValueAndUnits valueAndUnits = new MeasurementNumericValueAndUnits(origin, baseUnit);
        Double results = MeasurementConverter.scale(valueAndUnits, targetUnits);
        if (wasNegative) {
            results = -results.doubleValue();
        }
        return results;
    }

    public static String format(String value, MeasurementUnits targetUnits) {
        if (targetUnits == null) {
            return value;
        }
        return value + (Object)((Object)targetUnits);
    }

    public static String[] formatToSignificantPrecision(double[] values, MeasurementUnits targetUnits, boolean bestFit) {
        if (null == values || values.length == 0) {
            return null;
        }
        MeasurementUnits originalUnits = targetUnits;
        if (bestFit) {
            MeasurementUnits fittedUnits;
            Double average = 0.0;
            int sz = values.length;
            for (int i = 0; i < sz; ++i) {
                average = average + values[i] / (double)sz;
            }
            MeasurementNumericValueAndUnits fittedAverage = MeasurementConverter.fit(average, targetUnits);
            targetUnits = fittedUnits = fittedAverage.getUnits();
        }
        int precisionDigits = 0;
        boolean scaleWithMorePrecision = true;
        String[] results = new String[values.length];
        NumberFormat nf = MeasurementConverter.getDefaultNumberFormat();
        block1: while (scaleWithMorePrecision && ++precisionDigits <= 4) {
            int i;
            scaleWithMorePrecision = false;
            HashSet<String> existingStrings = new HashSet<String>();
            nf.setMinimumFractionDigits(0);
            nf.setMaximumFractionDigits(precisionDigits);
            Double[] scaledValues = new Double[values.length];
            for (i = 0; i < scaledValues.length; ++i) {
                scaledValues[i] = MeasurementUnits.Family.RELATIVE == originalUnits.getFamily() ? MeasurementUnits.scaleUp(values[i], originalUnits) : MeasurementConverter.scale(new MeasurementNumericValueAndUnits(values[i], originalUnits), targetUnits);
            }
            for (i = 0; i < results.length; ++i) {
                String formatted = nf.format(scaledValues[i]);
                boolean wasNewElement = existingStrings.add(formatted);
                if (!wasNewElement && precisionDigits < 4) {
                    scaleWithMorePrecision = true;
                    continue block1;
                }
                results[i] = formatted;
            }
        }
        for (int i = 0; i < results.length; ++i) {
            results[i] = MeasurementConverter.format(results[i], targetUnits);
        }
        return results;
    }

    public static String format(Double value, MeasurementUnits targetUnits, boolean bestFit) {
        return MeasurementConverter.format(value, targetUnits, bestFit, null, null);
    }

    public static String format(Double value, MeasurementUnits targetUnits, boolean bestFit, Integer minimumFractionDigits, Integer maximumFractionDigits) {
        if (value == null || Double.isNaN(value)) {
            return NULL_OR_NAN_FORMATTED_VALUE;
        }
        if (bestFit) {
            MeasurementNumericValueAndUnits valueAndUnits = MeasurementConverter.fit(value, targetUnits);
            value = valueAndUnits.getValue();
            targetUnits = valueAndUnits.getUnits();
        }
        if (MeasurementUnits.Family.RELATIVE == targetUnits.getFamily()) {
            value = MeasurementUnits.scaleUp(value, targetUnits);
        }
        NumberFormat numberFormat = MeasurementConverter.getDefaultNumberFormat();
        if (null != minimumFractionDigits) {
            numberFormat.setMinimumFractionDigits(minimumFractionDigits);
        }
        if (null != maximumFractionDigits) {
            numberFormat.setMaximumFractionDigits(maximumFractionDigits);
        }
        String formatted = numberFormat.format(value);
        return MeasurementConverter.format(formatted, targetUnits);
    }

    public static String scaleAndFormat(Double origin, MeasurementSchedule targetSchedule, boolean bestFit) throws MeasurementConversionException {
        MeasurementUnits targetUnits = targetSchedule.getDefinition().getUnits();
        return MeasurementConverter.scaleAndFormat(origin, targetUnits, bestFit, null, null);
    }

    public static String scaleAndFormat(Double origin, MeasurementUnits targetUnits, boolean bestFit) throws MeasurementConversionException {
        return MeasurementConverter.scaleAndFormat(origin, targetUnits, bestFit, null, null);
    }

    public static String scaleAndFormat(Double origin, MeasurementUnits targetUnits, boolean bestFit, Integer minimumFractionDigits, Integer maximumFractionDigits) throws MeasurementConversionException {
        MeasurementUnits baseUnits = targetUnits.getBaseUnits();
        MeasurementNumericValueAndUnits valueAndUnits = new MeasurementNumericValueAndUnits(origin, baseUnits);
        Double scaledMagnitude = MeasurementConverter.scale(valueAndUnits, targetUnits);
        return MeasurementConverter.format(scaledMagnitude, targetUnits, bestFit);
    }

    public static MeasurementNumericValueAndUnits fit(Double origin, MeasurementUnits units) {
        return MeasurementConverter.fit(origin, units, null, null);
    }

    public static MeasurementNumericValueAndUnits fit(Double origin, MeasurementUnits units, MeasurementUnits lowUnits, MeasurementUnits highUnits) {
        MeasurementUnits smallerUnits;
        int nextOrdinal;
        int minOrdinal;
        Double smallerValue;
        MeasurementUnits biggerUnits;
        MeasurementNumericValueAndUnits currentValueAndUnits;
        int nextOrdinal2;
        int maxOrdinal;
        if (null == units) {
            return new MeasurementNumericValueAndUnits(origin, units);
        }
        if (MeasurementUnits.Family.ABSOLUTE == units.getFamily() || MeasurementUnits.Family.DURATION == units.getFamily()) {
            return new MeasurementNumericValueAndUnits(origin, units);
        }
        if (MeasurementUnits.Family.RELATIVE == units.getFamily()) {
            return new MeasurementNumericValueAndUnits(origin, units);
        }
        if (Math.abs(origin) < 1.0E-9) {
            return new MeasurementNumericValueAndUnits(origin, units);
        }
        boolean wasNegative = false;
        if (origin < 0.0) {
            wasNegative = true;
            origin = -origin.doubleValue();
        }
        MeasurementNumericValueAndUnits nextValueAndUnits = new MeasurementNumericValueAndUnits(origin, units);
        int n = maxOrdinal = highUnits != null ? highUnits.ordinal() + 1 : MeasurementUnits.values().length;
        while ((nextOrdinal2 = (currentValueAndUnits = nextValueAndUnits).getUnits().ordinal() + 1) != maxOrdinal && (biggerUnits = MeasurementUnits.values()[nextOrdinal2]).getFamily() == currentValueAndUnits.getUnits().getFamily() && (nextValueAndUnits = new MeasurementNumericValueAndUnits(smallerValue = MeasurementConverter.scale(currentValueAndUnits, biggerUnits), biggerUnits)).getValue() > 1.0) {
        }
        int n2 = minOrdinal = lowUnits != null ? lowUnits.ordinal() - 1 : -1;
        while (currentValueAndUnits.getValue() < 1.0 && (nextOrdinal = currentValueAndUnits.getUnits().ordinal() - 1) != minOrdinal && (smallerUnits = MeasurementUnits.values()[nextOrdinal]).getFamily() == currentValueAndUnits.getUnits().getFamily()) {
            Double biggerValue = MeasurementConverter.scale(currentValueAndUnits, smallerUnits);
            currentValueAndUnits = nextValueAndUnits = new MeasurementNumericValueAndUnits(biggerValue, smallerUnits);
        }
        if (wasNegative) {
            return new MeasurementNumericValueAndUnits(-currentValueAndUnits.getValue().doubleValue(), currentValueAndUnits.getUnits());
        }
        return currentValueAndUnits;
    }
}

