/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.resource;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.resource.DeleteResourceStatus;
import org.rhq.core.domain.resource.Resource;

@Entity(name="DeleteResourceHistory")
@NamedQueries(value={@NamedQuery(name="DeleteResourceHistory.findWithStatus", query="SELECT drh from DeleteResourceHistory AS drh where drh.status = :status"), @NamedQuery(name="DeleteResourceHistory.findByParentResourceId", query="SELECT drh   FROM DeleteResourceHistory AS drh  WHERE drh.resource.parentResource.id = :id    AND ( drh.ctime > :startTime OR :startTime IS NULL )    AND ( drh.mtime < :endTime OR :endTime IS NULL ) "), @NamedQuery(name="DeleteResourceHistory.deleteByResources", query="DELETE FROM DeleteResourceHistory drh WHERE drh.resource IN (:resources))")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_DELETE_RES_HIST_ID_SEQ")
@Table(name="RHQ_DELETE_RES_HIST")
public class DeleteResourceHistory {
    public static final String QUERY_FIND_WITH_STATUS = "DeleteResourceHistory.findWithStatus";
    public static final String QUERY_FIND_BY_PARENT_RESOURCE_ID = "DeleteResourceHistory.findByParentResourceId";
    public static final String QUERY_DELETE_BY_RESOURCES = "DeleteResourceHistory.deleteByResources";
    @GeneratedValue(generator="SEQ", strategy=GenerationType.SEQUENCE)
    @Id
    private int id;
    @Column(name="ERROR_MESSAGE")
    private String errorMessage;
    @Column(name="SUBJECT_NAME", nullable=false)
    private String subjectName;
    @Column(name="CTIME", nullable=false)
    private long ctime = System.currentTimeMillis();
    @Column(name="MTIME", nullable=false)
    private long mtime = System.currentTimeMillis();
    @Column(name="STATUS", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private DeleteResourceStatus status;
    @JoinColumn(name="RESOURCE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne
    private Resource resource;

    public DeleteResourceHistory() {
    }

    public DeleteResourceHistory(Resource resource, String subjectName) {
        this.resource = resource;
        this.subjectName = subjectName;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (errorMessage != null) {
            this.setStatus(DeleteResourceStatus.FAILURE);
        }
    }

    public void setErrorMessageFromThrowable(Throwable t) {
        if (t != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(baos));
            this.setErrorMessage(baos.toString());
        } else {
            this.setErrorMessage(null);
        }
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public long getCreatedTime() {
        return this.ctime;
    }

    public Date getCreatedDate() {
        return new Date(this.ctime);
    }

    public long getLastModifiedTime() {
        return this.mtime;
    }

    public Date getLastModifiedDate() {
        return new Date(this.mtime);
    }

    public DeleteResourceStatus getStatus() {
        return this.status;
    }

    public void setStatus(DeleteResourceStatus status) {
        this.status = status;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public long getDuration() {
        long start = this.ctime;
        long end = this.mtime;
        if (this.status == null || this.status == DeleteResourceStatus.IN_PROGRESS) {
            end = System.currentTimeMillis();
        }
        return end - start;
    }

    @PrePersist
    void onPersist() {
        this.mtime = System.currentTimeMillis();
    }

    @PreUpdate
    void onUpdate() {
        this.mtime = System.currentTimeMillis();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(this.ctime ^ this.ctime >>> 32);
        result = 31 * result + (this.subjectName == null ? 0 : this.subjectName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DeleteResourceHistory)) {
            return false;
        }
        DeleteResourceHistory other = (DeleteResourceHistory)obj;
        if (this.ctime != other.ctime) {
            return false;
        }
        return !(this.subjectName == null ? other.subjectName != null : !this.subjectName.equals(other.subjectName));
    }
}

