/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.record.FontRecord;

public class HSSFFont {
    public static final String FONT_ARIAL = "Arial";
    public static final short BOLDWEIGHT_NORMAL = 400;
    public static final short BOLDWEIGHT_BOLD = 700;
    public static final short COLOR_NORMAL = Short.MAX_VALUE;
    public static final short COLOR_RED = 10;
    public static final short SS_NONE = 0;
    public static final short SS_SUPER = 1;
    public static final short SS_SUB = 2;
    public static final byte U_NONE = 0;
    public static final byte U_SINGLE = 1;
    public static final byte U_DOUBLE = 2;
    public static final byte U_SINGLE_ACCOUNTING = 33;
    public static final byte U_DOUBLE_ACCOUNTING = 34;
    public static final byte ANSI_CHARSET = 0;
    public static final byte DEFAULT_CHARSET = 1;
    public static final byte SYMBOL_CHARSET = 2;
    private FontRecord font;
    private short index;

    protected HSSFFont(short index, FontRecord rec) {
        this.font = rec;
        this.index = index;
    }

    public void setFontName(String name) {
        this.font.setFontName(name);
        this.font.setFontNameLength((byte)name.length());
    }

    public String getFontName() {
        return this.font.getFontName();
    }

    public short getIndex() {
        return this.index;
    }

    public void setFontHeight(short height) {
        this.font.setFontHeight(height);
    }

    public void setFontHeightInPoints(short height) {
        this.font.setFontHeight((short)(height * 20));
    }

    public short getFontHeight() {
        return this.font.getFontHeight();
    }

    public short getFontHeightInPoints() {
        return (short)(this.font.getFontHeight() / 20);
    }

    public void setItalic(boolean italic) {
        this.font.setItalic(italic);
    }

    public boolean getItalic() {
        return this.font.isItalic();
    }

    public void setStrikeout(boolean strikeout) {
        this.font.setStrikeout(strikeout);
    }

    public boolean getStrikeout() {
        return this.font.isStruckout();
    }

    public void setColor(short color) {
        this.font.setColorPaletteIndex(color);
    }

    public short getColor() {
        return this.font.getColorPaletteIndex();
    }

    public void setBoldweight(short boldweight) {
        this.font.setBoldWeight(boldweight);
    }

    public short getBoldweight() {
        return this.font.getBoldWeight();
    }

    public void setTypeOffset(short offset) {
        this.font.setSuperSubScript(offset);
    }

    public short getTypeOffset() {
        return this.font.getSuperSubScript();
    }

    public void setUnderline(byte underline) {
        this.font.setUnderline(underline);
    }

    public byte getUnderline() {
        return this.font.getUnderline();
    }

    public byte getCharSet() {
        return this.font.getCharset();
    }

    public void setCharSet(byte charset) {
        this.font.setCharset(charset);
    }

    public String toString() {
        return "org.apache.poi.hssf.usermodel.HSSFFont{" + this.font + "}";
    }
}

