/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.opensocial.spi;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.social.core.model.ActivityImpl;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.spi.ActivityService;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.SocialSpiException;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.activitystream.ActivityManager;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.opensocial.spi.ExoService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoActivityService
extends ExoService
implements ActivityService {
    public static final String OPENSOCIAL_PREFIX = "opensocial:";
    public static final int OPENSOCIAL_PREFIX_LENGTH = "opensocial:".length();

    public Future<RestfulCollection<Activity>> getActivities(Set<UserId> userIds, GroupId groupId, String appId, Set<String> fields, CollectionOptions options, SecurityToken token) throws SocialSpiException {
        ArrayList result = Lists.newArrayList();
        PortalContainer pc = this.getPortalContainer(token);
        ActivityManager am = (ActivityManager)pc.getComponentInstanceOfType(ActivityManager.class);
        try {
            Set<Identity> idSet = this.getIdSet(userIds, groupId, token);
            for (Identity id : idSet) {
                List activities = am.getActivities(id, (long)options.getFirst(), (long)options.getMax());
                result.addAll(this.convertToOSActivities(activities, fields));
            }
            return ImmediateFuture.newInstance((Object)new RestfulCollection((List)result, 0, result.size()));
        }
        catch (Exception je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    public Future<RestfulCollection<Activity>> getActivities(UserId userId, GroupId groupId, String appId, Set<String> fields, CollectionOptions options, Set<String> activityIds, SecurityToken token) throws SocialSpiException {
        ArrayList result = Lists.newArrayList();
        try {
            if (token instanceof AnonymousSecurityToken) {
                throw new Exception(Integer.toString(403));
            }
            PortalContainer pc = this.getPortalContainer(token);
            ActivityManager am = (ActivityManager)pc.getComponentInstanceOfType(ActivityManager.class);
            String user = userId.getUserId(token);
            Identity id = this.getIdentity(user, token);
            List exoActivities = am.getActivities(id, (long)options.getFirst(), (long)options.getMax());
            for (org.exoplatform.social.core.activitystream.model.Activity exoActivity : exoActivities) {
                if (exoActivity.getType() == null || !exoActivity.getType().startsWith(OPENSOCIAL_PREFIX)) continue;
                if (activityIds.contains(exoActivity.getType().substring(OPENSOCIAL_PREFIX_LENGTH))) {
                    // empty if block
                }
                result.add(this.convertToOSActivity(exoActivity, fields));
            }
            return ImmediateFuture.newInstance((Object)new RestfulCollection((List)result, 0, result.size()));
        }
        catch (Exception je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    public Future<Activity> getActivity(UserId userId, GroupId groupId, String appId, Set<String> fields, String activityId, SecurityToken token) throws SocialSpiException {
        throw new ProtocolException(501, null);
    }

    public Future<Void> deleteActivities(UserId userId, GroupId groupId, String appId, Set<String> activityIds, SecurityToken token) throws SocialSpiException {
        throw new ProtocolException(501, null);
    }

    public Future<Void> createActivity(UserId userId, GroupId groupId, String appId, Set<String> fields, Activity activity, SecurityToken token) throws SocialSpiException {
        try {
            Identity userIdentity;
            activity.setAppId(appId);
            org.exoplatform.social.core.activitystream.model.Activity exoActivity = this.convertFromOSActivity(activity, fields);
            if (token instanceof AnonymousSecurityToken) {
                throw new ProtocolException(401, " a non anonymous security token is expected");
            }
            PortalContainer pc = this.getPortalContainer(token);
            ActivityManager am = (ActivityManager)pc.getComponentInstanceOfType(ActivityManager.class);
            IdentityManager identityManager = (IdentityManager)pc.getComponentInstanceOfType(IdentityManager.class);
            String user = userId.getUserId(token);
            Identity targetStream = userIdentity = identityManager.getIdentity(user);
            if (groupId.getType() == GroupId.Type.groupId) {
                String group = groupId.getGroupId();
                targetStream = identityManager.getIdentity(group);
            }
            if (targetStream == null) {
                throw new ProtocolException(403, user + " is an unknown identity");
            }
            String activityUser = exoActivity.getUserId();
            if (activityUser == null) {
                exoActivity.setUserId(userIdentity.getId());
            } else {
                Identity activityUserIdentity = identityManager.getIdentity(activityUser);
                if (activityUserIdentity == null) {
                    throw new ProtocolException(403, activityUser + " is an unknown identity");
                }
            }
            am.saveActivity(targetStream, exoActivity);
            return ImmediateFuture.newInstance(null);
        }
        catch (Throwable e) {
            if (e instanceof ProtocolException) {
                throw (ProtocolException)e;
            }
            throw new ProtocolException(500, e.getMessage(), e);
        }
    }

    private org.exoplatform.social.core.activitystream.model.Activity convertFromOSActivity(Activity activity, Set<String> fields) {
        org.exoplatform.social.core.activitystream.model.Activity exoActivity = new org.exoplatform.social.core.activitystream.model.Activity();
        if (fields != null && !fields.isEmpty()) {
            for (String field : fields) {
                if (field.equals(Activity.Field.APP_ID.name())) {
                    exoActivity.setAppId(activity.getAppId());
                }
                if (field.equals(Activity.Field.BODY.name())) {
                    exoActivity.setBody(activity.getBody());
                }
                if (field.equals(Activity.Field.BODY_ID.name())) {
                    exoActivity.setBodyId(activity.getBodyId());
                }
                if (field.equals(Activity.Field.EXTERNAL_ID.name())) {
                    exoActivity.setExternalId(activity.getExternalId());
                }
                if (field.equals(Activity.Field.ID.name())) {
                    exoActivity.setId(activity.getId());
                }
                if (field.equals(Activity.Field.MEDIA_ITEMS.name())) {
                    exoActivity.setMediaItems(activity.getMediaItems());
                }
                if (field.equals(Activity.Field.POSTED_TIME.name())) {
                    exoActivity.setPostedTime(activity.getPostedTime());
                }
                if (field.equals(Activity.Field.LAST_UPDATED.name())) {
                    exoActivity.setUpdated(activity.getUpdated());
                }
                if (field.equals(Activity.Field.PRIORITY.name())) {
                    exoActivity.setPriority(activity.getPriority());
                }
                if (field.equals(Activity.Field.STREAM_FAVICON_URL.name())) {
                    exoActivity.setStreamFaviconUrl(activity.getStreamFaviconUrl());
                }
                if (field.equals(Activity.Field.STREAM_SOURCE_URL.name())) {
                    exoActivity.setStreamSourceUrl(activity.getStreamSourceUrl());
                }
                if (field.equals(Activity.Field.STREAM_TITLE.name())) {
                    exoActivity.setStreamTitle(activity.getStreamTitle());
                }
                if (field.equals(Activity.Field.STREAM_URL.name())) {
                    exoActivity.setStreamUrl(activity.getStreamUrl());
                }
                if (field.equals(Activity.Field.TEMPLATE_PARAMS.name())) {
                    exoActivity.setTemplateParams(activity.getTemplateParams());
                }
                if (field.equals(Activity.Field.TITLE.name())) {
                    exoActivity.setTitle(activity.getTitle());
                }
                if (field.equals(Activity.Field.TITLE_ID)) {
                    exoActivity.setTitleId(activity.getTitleId());
                }
                if (field.equals(Activity.Field.URL)) {
                    exoActivity.setUrl(activity.getUrl());
                }
                if (!field.equals(Activity.Field.USER_ID)) continue;
                exoActivity.setUserId(activity.getUserId());
            }
        } else {
            exoActivity.setAppId(activity.getAppId());
            exoActivity.setBody(activity.getBody());
            exoActivity.setBodyId(activity.getBodyId());
            exoActivity.setExternalId(activity.getExternalId());
            exoActivity.setId(activity.getId());
            exoActivity.setMediaItems(activity.getMediaItems());
            exoActivity.setPostedTime(activity.getPostedTime());
            exoActivity.setPriority(activity.getPriority());
            exoActivity.setStreamFaviconUrl(activity.getStreamFaviconUrl());
            exoActivity.setStreamSourceUrl(activity.getStreamSourceUrl());
            exoActivity.setStreamTitle(activity.getStreamTitle());
            exoActivity.setStreamUrl(activity.getStreamUrl());
            exoActivity.setTemplateParams(activity.getTemplateParams());
            exoActivity.setTitle(activity.getTitle());
            exoActivity.setTitleId(activity.getTitleId());
            exoActivity.setUpdated(activity.getUpdated());
            exoActivity.setUrl(activity.getUrl());
            exoActivity.setUserId(activity.getUserId());
        }
        return exoActivity;
    }

    private Activity convertToOSActivity(org.exoplatform.social.core.activitystream.model.Activity exoActivity, Set<String> fields) {
        ActivityImpl activity = new ActivityImpl();
        if (fields != null && !fields.isEmpty()) {
            for (String field : fields) {
                if (field.equals(Activity.Field.APP_ID.name())) {
                    activity.setAppId(exoActivity.getAppId());
                }
                if (field.equals(Activity.Field.BODY.name())) {
                    activity.setBody(exoActivity.getBody());
                }
                if (field.equals(Activity.Field.BODY_ID.name())) {
                    activity.setBodyId(exoActivity.getBodyId());
                }
                if (field.equals(Activity.Field.EXTERNAL_ID.name())) {
                    activity.setExternalId(exoActivity.getExternalId());
                }
                if (field.equals(Activity.Field.ID.name())) {
                    activity.setId(exoActivity.getId());
                }
                if (field.equals(Activity.Field.MEDIA_ITEMS.name())) {
                    activity.setMediaItems(exoActivity.getMediaItems());
                }
                if (field.equals(Activity.Field.POSTED_TIME.name())) {
                    activity.setPostedTime(exoActivity.getPostedTime());
                }
                if (field.equals(Activity.Field.LAST_UPDATED.name())) {
                    activity.setUpdated(exoActivity.getUpdated());
                }
                if (field.equals(Activity.Field.PRIORITY.name())) {
                    activity.setPriority(exoActivity.getPriority());
                }
                if (field.equals(Activity.Field.STREAM_FAVICON_URL.name())) {
                    activity.setStreamFaviconUrl(exoActivity.getStreamFaviconUrl());
                }
                if (field.equals(Activity.Field.STREAM_SOURCE_URL.name())) {
                    activity.setStreamSourceUrl(exoActivity.getStreamSourceUrl());
                }
                if (field.equals(Activity.Field.STREAM_TITLE.name())) {
                    activity.setStreamTitle(exoActivity.getStreamTitle());
                }
                if (field.equals(Activity.Field.STREAM_URL.name())) {
                    activity.setStreamUrl(exoActivity.getStreamUrl());
                }
                if (field.equals(Activity.Field.TEMPLATE_PARAMS.name())) {
                    activity.setTemplateParams(exoActivity.getTemplateParams());
                }
                if (field.equals(Activity.Field.TITLE.name())) {
                    activity.setTitle(exoActivity.getTitle());
                }
                if (field.equals(Activity.Field.TITLE_ID)) {
                    activity.setTitleId(exoActivity.getTitleId());
                }
                if (field.equals(Activity.Field.URL)) {
                    activity.setUrl(exoActivity.getUrl());
                }
                if (!field.equals(Activity.Field.USER_ID)) continue;
                activity.setUserId(exoActivity.getUserId());
            }
        } else {
            activity.setAppId(exoActivity.getAppId());
            activity.setBody(exoActivity.getBody());
            activity.setBodyId(exoActivity.getBodyId());
            activity.setExternalId(exoActivity.getExternalId());
            activity.setId(exoActivity.getId());
            activity.setMediaItems(exoActivity.getMediaItems());
            activity.setPostedTime(exoActivity.getPostedTime());
            activity.setPriority(exoActivity.getPriority());
            activity.setStreamFaviconUrl(exoActivity.getStreamFaviconUrl());
            activity.setStreamSourceUrl(exoActivity.getStreamSourceUrl());
            activity.setStreamTitle(exoActivity.getStreamTitle());
            activity.setStreamUrl(exoActivity.getStreamUrl());
            activity.setTemplateParams(exoActivity.getTemplateParams());
            activity.setTitle(exoActivity.getTitle());
            activity.setTitleId(exoActivity.getTitleId());
            activity.setUpdated(exoActivity.getUpdated());
            activity.setUrl(exoActivity.getUrl());
            activity.setUserId(exoActivity.getUserId());
        }
        return activity;
    }

    private List<Activity> convertToOSActivities(List<org.exoplatform.social.core.activitystream.model.Activity> activities, Set<String> fields) {
        ArrayList res = Lists.newArrayList();
        for (org.exoplatform.social.core.activitystream.model.Activity activity : activities) {
            res.add(this.convertToOSActivity(activity, fields));
        }
        return res;
    }

    private List<Activity> sortActivity(List<Activity> lstActivities) {
        Collections.sort(lstActivities, new ActivityComparator());
        return lstActivities;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActivityComparator
    implements Comparator<Activity> {
        private ActivityComparator() {
        }

        @Override
        public int compare(Activity act1, Activity act2) {
            return (int)(act2.getPostedTime() - act1.getPostedTime());
        }
    }
}

