/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;

public class XMLDocumentReader
extends BaseDocumentReader {
    public String[] getMimeTypes() {
        return new String[]{"text/xml", "application/xml", "application/x-google-gadget"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentAsText(InputStream is) throws IOException, DocumentReadException {
        if (is == null) {
            throw new NullPointerException("InputStream is null.");
        }
        try {
            int len;
            byte[] buffer = new byte[2048];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((len = is.read(buffer)) > 0) {
                bos.write(buffer, 0, len);
            }
            bos.close();
            String xml = new String(bos.toByteArray());
            String string = this.delete(xml);
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    public Properties getProperties(InputStream is) throws IOException, DocumentReadException {
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Properties();
    }

    private String delete(String str) {
        try {
            StringBuffer input = new StringBuffer(str);
            String patternString = "<+[^>]*>+";
            Pattern pattern = Pattern.compile(patternString, 34);
            Matcher matcher = pattern.matcher(input);
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                input.delete(start, end);
                matcher = pattern.matcher(input);
            }
            return input.substring(0, input.length());
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return "";
        }
    }
}

