/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.utils.JBossWSEntityResolver;
import org.jboss.ws.metadata.config.CommonConfig;
import org.jboss.ws.metadata.config.binding.OMFactoryJAXRPC;
import org.jboss.ws.metadata.config.binding.OMFactoryJAXWS;
import org.jboss.ws.metadata.config.jaxrpc.ConfigRootJAXRPC;
import org.jboss.ws.metadata.config.jaxws.ConfigRootJAXWS;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.wsf.common.ResourceLoaderAdapter;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class JBossWSConfigFactory {
    private final Logger log = Logger.getLogger(JBossWSConfigFactory.class);
    private static String URN_JAXRPC_CONFIG = "urn:jboss:jaxrpc-config:2.0";
    private static String URN_JAXWS_CONFIG = "urn:jboss:jaxws-config:2.0";

    private JBossWSConfigFactory() {
    }

    public static JBossWSConfigFactory newInstance() {
        return new JBossWSConfigFactory();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object parse(URL configURL) {
        Object wsConfig;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("parse: " + configURL));
        }
        InputStream is = null;
        Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        unmarshaller.setValidation(true);
        unmarshaller.setSchemaValidation(true);
        unmarshaller.setEntityResolver((EntityResolver)new JBossWSEntityResolver());
        String nsURI = this.getNamespaceURI(configURL);
        is = configURL.openStream();
        if (URN_JAXRPC_CONFIG.equals(nsURI)) {
            wsConfig = unmarshaller.unmarshal(is, (ObjectModelFactory)new OMFactoryJAXRPC(), null);
        } else {
            if (!URN_JAXWS_CONFIG.equals(nsURI)) throw new WSException("Invalid config namespace: " + nsURI);
            wsConfig = unmarshaller.unmarshal(is, (ObjectModelFactory)new OMFactoryJAXWS(), null);
        }
        Object var7_8 = null;
        if (is == null) return wsConfig;
        try {
            is.close();
            return wsConfig;
        }
        catch (IOException ioe) {
            if (!this.log.isDebugEnabled()) return wsConfig;
            this.log.warn((Object)ioe.getMessage(), (Throwable)ioe);
        }
        return wsConfig;
        {
            catch (JBossXBException e) {
                throw new WSException("Error while parsing configuration", e);
            }
            catch (IOException e) {
                throw new WSException("Failed to read config file: " + configURL, e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ioe) {
                if (!this.log.isDebugEnabled()) throw throwable;
                this.log.warn((Object)ioe.getMessage(), (Throwable)ioe);
            }
            throw throwable;
        }
    }

    private String getNamespaceURI(URL configURL) {
        try {
            Element root = DOMUtils.parse((InputStream)configURL.openStream());
            return root.getNamespaceURI();
        }
        catch (IOException ex) {
            throw new WSException(ex);
        }
    }

    public CommonConfig getConfig(UnifiedVirtualFile vfsRoot, String configName, String configFile) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getConfig: [name=" + configName + ",url=" + configFile + "]"));
        }
        if (configName == null) {
            throw new IllegalArgumentException("Config name cannot be null");
        }
        if (configFile == null) {
            throw new IllegalArgumentException("Config file cannot be null");
        }
        URL configURL = this.filenameToURL(vfsRoot, configFile);
        Object configRoot = this.parse(configURL);
        CommonConfig config = configRoot instanceof ConfigRootJAXRPC ? ((ConfigRootJAXRPC)configRoot).getConfigByName(configName) : ((ConfigRootJAXWS)configRoot).getConfigByName(configName);
        if (config == null) {
            throw new WSException("Cannot obtain config: " + configName);
        }
        return config;
    }

    private URL filenameToURL(UnifiedVirtualFile vfsRoot, String configFile) {
        URL configURL = null;
        try {
            configURL = vfsRoot.findChild(configFile).toURL();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (configURL == null) {
            try {
                configURL = new ResourceLoaderAdapter().findChild(configFile).toURL();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (configURL == null) {
            throw new WSException("Cannot find configFile: " + configFile);
        }
        return configURL;
    }
}

