/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.Dynamic;
import org.jboss.cache.eviction.EvictionAlgorithmConfigBase;
import org.jboss.cache.eviction.LFUAlgorithm;

public class LFUAlgorithmConfig
extends EvictionAlgorithmConfigBase {
    private static final long serialVersionUID = 1865801530398969179L;
    @Dynamic
    private int minNodes = -1;

    public LFUAlgorithmConfig() {
        this.evictionAlgorithmClassName = LFUAlgorithm.class.getName();
    }

    public LFUAlgorithmConfig(int maxNodes, int minNodes) {
        this();
        this.setMaxNodes(maxNodes);
        this.setMinNodes(minNodes);
    }

    public int getMinNodes() {
        return this.minNodes;
    }

    public void setMinNodes(int minNodes) {
        this.testImmutability("minNodes");
        this.minNodes = minNodes;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("LFUAlgorithmConfig: maxNodes = ").append(this.getMaxNodes()).append(" minNodes = ").append(this.getMinNodes());
        return ret.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LFUAlgorithmConfig && super.equals(obj)) {
            return this.minNodes == ((LFUAlgorithmConfig)obj).minNodes;
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.minNodes;
        return result;
    }

    public LFUAlgorithmConfig clone() throws CloneNotSupportedException {
        return (LFUAlgorithmConfig)super.clone();
    }

    public void reset() {
        super.reset();
        this.minNodes = -1;
        this.evictionAlgorithmClassName = LFUAlgorithm.class.getName();
    }
}

