/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.metadata;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.jboss.system.server.profileservice.repository.clustered.metadata.Identifiable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(name="repositoryItemType", propOrder={"timestampAsString", "originatingNode", "removed", "directory", "relativePath"})
public class RepositoryItemMetadata
implements Identifiable<List<String>>,
Serializable,
Comparable<RepositoryItemMetadata> {
    private static final long serialVersionUID = 7712110893517082031L;
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static String NOW = "NOW";
    private volatile String relativePath;
    private volatile long timestamp;
    private volatile boolean directory;
    private volatile transient List<String> pathElements;
    private volatile String originatingNode;
    private volatile boolean removed;
    private String rootName;

    public static List<String> getPathElements(String path) {
        String[] elements = path.split("/");
        return Collections.unmodifiableList(Arrays.asList(elements));
    }

    public RepositoryItemMetadata() {
    }

    public RepositoryItemMetadata(List<String> pathElements, long timestamp, String originatingNode, boolean directory, boolean removed) {
        this.setDirectory(directory);
        this.setRelativePathElements(pathElements);
        this.setTimestamp(timestamp);
        this.setOriginatingNode(originatingNode);
        this.setRemoved(removed);
    }

    public RepositoryItemMetadata(RepositoryItemMetadata toCopy) {
        this(toCopy.getRelativePathElements(), toCopy.getTimestamp(), toCopy.getOriginatingNode(), toCopy.isDirectory(), toCopy.isRemoved());
    }

    @Override
    public List<String> getId() {
        return this.getRelativePathElements();
    }

    @XmlTransient
    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    @XmlAttribute(name="relative-path", required=true)
    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String path) {
        if (path != null && path.length() > 0 && '/' == path.charAt(0)) {
            path = path.length() == 0 ? "" : path.substring(1);
        }
        this.relativePath = path;
        this.pathElements = null;
    }

    @XmlAttribute(name="directory")
    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
        if (this.relativePath != null) {
            if (!directory && this.relativePath.endsWith("/")) {
                this.relativePath = this.relativePath.substring(0, this.relativePath.length() - 1);
            } else if (directory && !this.relativePath.endsWith("/")) {
                this.relativePath = this.relativePath + "/";
            }
        }
    }

    @XmlTransient
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XmlAttribute(name="timestamp", required=true)
    public String getTimestampAsString() {
        Date d = new Date(this.timestamp);
        DateFormat dateFormat = RepositoryItemMetadata.dateFormat;
        synchronized (dateFormat) {
            return RepositoryItemMetadata.dateFormat.format(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestampAsString(String timestamp) {
        if (NOW.equals(timestamp)) {
            this.setTimestamp(System.currentTimeMillis());
        } else {
            try {
                DateFormat dateFormat = RepositoryItemMetadata.dateFormat;
                synchronized (dateFormat) {
                    Date d = RepositoryItemMetadata.dateFormat.parse(timestamp);
                    this.setTimestamp(d.getTime());
                }
            }
            catch (ParseException e) {
                throw new RuntimeException("Failed to parse " + timestamp, e);
            }
        }
    }

    @XmlTransient
    public List<String> getRelativePathElements() {
        if (this.pathElements == null && this.relativePath != null) {
            String[] elements = this.relativePath.split("/");
            this.setRelativePathElements(Arrays.asList(elements));
        }
        return this.pathElements;
    }

    public void setRelativePathElements(List<String> pathElements) {
        if (pathElements == null) {
            this.pathElements = null;
            this.relativePath = null;
        } else {
            this.pathElements = Collections.unmodifiableList(new ArrayList<String>(pathElements));
            boolean first = true;
            StringBuilder sb = new StringBuilder();
            for (String element : pathElements) {
                if (!first) {
                    sb.append('/');
                } else {
                    first = false;
                }
                sb.append(element);
            }
            if (this.directory) {
                sb.append('/');
            }
            this.relativePath = sb.toString();
        }
    }

    @XmlAttribute(name="originator", required=true)
    public String getOriginatingNode() {
        return this.originatingNode;
    }

    public void setOriginatingNode(String originatingNode) {
        this.originatingNode = originatingNode;
    }

    @XmlAttribute(name="removed")
    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public boolean isChildOf(RepositoryItemMetadata other) {
        return other != null && other.isDirectory() && this.getRelativePath().startsWith(other.getRelativePath());
    }

    @Override
    public int compareTo(RepositoryItemMetadata o) {
        int result = 0;
        if (this != o) {
            if (this.relativePath != o.relativePath) {
                if (this.relativePath != null) {
                    result = o.relativePath == null ? 1 : this.relativePath.compareTo(o.relativePath);
                } else {
                    int n = result = o.relativePath == null ? 0 : -1;
                }
            }
            if (result == 0) {
                result = (int)(this.timestamp - o.timestamp);
            }
            if (result == 0 && this.directory != o.directory) {
                int n = result = this.directory ? 1 : -1;
            }
            if (result == 0 && this.removed != o.removed) {
                int n = result = this.removed ? 1 : -1;
            }
            if (result == 0) {
                result = this.originatingNode != null ? (o.originatingNode == null ? -1 : this.originatingNode.compareTo(o.originatingNode)) : (o.originatingNode == null ? 0 : 1);
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = this == obj;
        if (!result && obj instanceof RepositoryItemMetadata) {
            RepositoryItemMetadata other = (RepositoryItemMetadata)obj;
            result = this.timestamp == other.timestamp && this.removed == other.removed && this.directory == other.directory && RepositoryItemMetadata.safeEquals(this.getRelativePathElements(), other.getRelativePathElements()) && RepositoryItemMetadata.safeEquals(this.originatingNode, other.originatingNode);
        }
        return result;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.removed ? 0 : 1);
        result = 31 * result + (this.directory ? 0 : 1);
        List<String> elements = this.getRelativePathElements();
        result = 31 * result + (elements == null ? 0 : ((Object)elements).hashCode());
        result = 31 * result + (this.originatingNode == null ? 0 : this.originatingNode.hashCode());
        return result;
    }

    public String toString() {
        return this.getClass().getName() + "[path='" + this.relativePath + ",timestamp=" + this.timestamp + ",originatingNode=" + this.originatingNode + ",removed=" + this.removed + ']';
    }

    private static boolean safeEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

