/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.event;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.event.EventSource;

@NamedQueries(value={@NamedQuery(name="Event.deleteByResources", query="DELETE FROM Event ev   WHERE ev.source IN ( SELECT evs FROM EventSource evs WHERE evs.resource IN (:resources))"), @NamedQuery(name="Event.deleteByEventIds", query="DELETE FROM Event e WHERE e.id IN ( :eventIds )"), @NamedQuery(name="Event.deleteAllByResource", query="DELETE FROM Event e  WHERE e.source.id IN ( SELECT es.id                           FROM EventSource es                          WHERE es.resource.id = :resourceId )"), @NamedQuery(name="Event.deleteAllByResourceGroup", query="DELETE FROM Event e  WHERE e.source.id IN ( SELECT es.id                           FROM EventSource es                           JOIN es.resource res                           JOIN res.explicitGroups ig                          WHERE ig.id = :groupId )"), @NamedQuery(name="Event.FIND_EVENTS_FOR_RESOURCES_AND_TIME", query="SELECT ev FROM Event ev  JOIN ev.source.resource res WHERE res IN (:resources) AND ev.timestamp BETWEEN :start AND :end "), @NamedQuery(name="Event.FIND_EVENTS_FOR_RESOURCE_ID_AND_TIME", query="SELECT ev FROM Event ev  JOIN ev.source evs JOIN evs.resource res WHERE res.id = :resourceId AND ev.timestamp BETWEEN :start AND :end "), @NamedQuery(name="Event.FIND_EVENTS_FOR_RESOURCE_ID_AND_TIME_Severity", query="SELECT ev FROM Event ev  JOIN ev.source evs JOIN evs.resource res WHERE res.id = :resourceId AND ev.severity = :severity  AND ev.timestamp BETWEEN :start AND :end "), @NamedQuery(name="Event.GET_DETAILS_FOR_EVENT_IDS", query="SELECT  new org.rhq.core.domain.event.composite.EventComposite(ev.detail, res.id, res.name, ev.id, ev.severity, evs.location, ev.timestamp)  FROM Event ev JOIN ev.source evs JOIN evs.resource res WHERE ev.id IN (:eventIds) AND evs.id = ev.source  AND res.id = evs.resource "), @NamedQuery(name="Event.eventCountsBySeverity", query="  SELECT ev.severity, count(ev.severity)     FROM Event ev JOIN ev.source evs JOIN evs.resource res    WHERE res.id = :resourceId      AND ev.timestamp BETWEEN :start AND :end GROUP BY ev.severity")})
@Entity
@Table(name="RHQ_EVENT")
@SequenceGenerator(name="idGenerator", sequenceName="RHQ_EVENT_ID_SEQ", allocationSize=100)
public class Event
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TABLE_NAME = "RHQ_EVENT";
    public static final int DETAIL_MAX_LENGTH = 4000;
    public static final String DELETE_BY_RESOURCES = "Event.deleteByResources";
    public static final String DELETE_BY_EVENT_IDS = "Event.deleteByEventIds";
    public static final String DELETE_ALL_BY_RESOURCE = "Event.deleteAllByResource";
    public static final String DELETE_ALL_BY_RESOURCE_GROUP = "Event.deleteAllByResourceGroup";
    public static final String FIND_EVENTS_FOR_RESOURCES_AND_TIME = "Event.FIND_EVENTS_FOR_RESOURCES_AND_TIME";
    public static final String FIND_EVENTS_FOR_RESOURCE_ID_AND_TIME = "Event.FIND_EVENTS_FOR_RESOURCE_ID_AND_TIME";
    public static final String FIND_EVENTS_FOR_RESOURCE_ID_AND_TIME_SEVERITY = "Event.FIND_EVENTS_FOR_RESOURCE_ID_AND_TIME_Severity";
    public static final String GET_DETAILS_FOR_EVENT_IDS = "Event.GET_DETAILS_FOR_EVENT_IDS";
    public static final String QUERY_EVENT_COUNTS_BY_SEVERITY = "Event.eventCountsBySeverity";
    @Id
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="idGenerator")
    private int id;
    @JoinColumn(name="EVENT_SOURCE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private EventSource source;
    @Column(name="TIMESTAMP", nullable=false)
    private long timestamp;
    @Column(name="SEVERITY", length=20, nullable=false)
    @Enumerated(value=EnumType.STRING)
    private EventSeverity severity;
    @Column(name="DETAIL", length=4000, nullable=false)
    private String detail;
    @Transient
    private transient String detailExcerpt;
    @Transient
    private transient String type;
    @Transient
    private transient String sourceLocation;

    protected Event() {
    }

    public Event(@NotNull String type, @NotNull String sourceLocation, @NotNull long timestamp, @NotNull EventSeverity severity, @NotNull String detail) {
        if (type == null) {
            throw new IllegalArgumentException("type parameter must not be null.");
        }
        if (sourceLocation == null) {
            throw new IllegalArgumentException("sourceLocation parameter must not be null.");
        }
        if (severity == null) {
            throw new IllegalArgumentException("severity parameter must not be null.");
        }
        if (detail == null) {
            throw new IllegalArgumentException("detail parameter must not be null.");
        }
        this.type = type;
        this.sourceLocation = sourceLocation;
        this.timestamp = timestamp;
        this.severity = severity;
        this.detail = detail;
        if (this.detail.length() > 4000) {
            this.detail = this.detail.substring(0, 4000);
        }
    }

    public Event(@NotNull String type, @NotNull String sourceLocation, @NotNull long timestamp, @NotNull EventSeverity severity, @NotNull String detail, @Nullable EventSource source) {
        if (type == null) {
            throw new IllegalArgumentException("type parameter must not be null.");
        }
        if (sourceLocation == null) {
            throw new IllegalArgumentException("sourceLocation parameter must not be null.");
        }
        if (severity == null) {
            throw new IllegalArgumentException("severity parameter must not be null.");
        }
        if (detail == null) {
            throw new IllegalArgumentException("detail parameter must not be null.");
        }
        this.source = source;
        this.type = type;
        this.sourceLocation = sourceLocation;
        this.timestamp = timestamp;
        this.severity = severity;
        this.detail = detail;
        if (this.detail.length() > 4000) {
            this.detail = this.detail.substring(0, 4000);
        }
    }

    public int getId() {
        return this.id;
    }

    @Nullable
    public EventSource getSource() {
        return this.source;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @Nullable
    public String getSourceLocation() {
        return this.sourceLocation;
    }

    @NotNull
    public long getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public EventSeverity getSeverity() {
        return this.severity;
    }

    @NotNull
    public String getDetail() {
        return this.detail;
    }

    public String getDetailExcerpt() {
        int len = 100;
        if (this.detailExcerpt != null) {
            return this.detailExcerpt;
        }
        if (this.detail.length() < len) {
            len = this.detail.length();
        }
        this.detailExcerpt = this.detail.substring(0, len);
        return this.detailExcerpt;
    }

    public void setDetailExcerpt(String detailExcerpt) {
        this.detailExcerpt = detailExcerpt;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Event)) {
            return false;
        }
        Event that = (Event)obj;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (this.severity != that.severity) {
            return false;
        }
        return this.detail.equals(that.detail);
    }

    public int hashCode() {
        int result = 31 + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.severity.hashCode();
        result = 31 * result + this.detail.hashCode();
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "id=" + this.id + ", " + "source=" + this.source + ", " + "timestamp=" + this.timestamp + ", " + "severity=" + (Object)((Object)this.severity) + ", " + "detail=" + this.detail + "]";
    }
}

