/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.remoting;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.util.Map;
import org.jboss.jms.client.container.ClientConsumer;
import org.jboss.jms.client.remoting.ConnectionFactoryCallbackHandler;
import org.jboss.jms.wireformat.ClientDelivery;
import org.jboss.jms.wireformat.ConnectionFactoryUpdate;
import org.jboss.logging.Logger;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;

public class CallbackManager
implements InvokerCallbackHandler {
    private static final Logger log = Logger.getLogger(CallbackManager.class);
    public static final String JMS_CALLBACK_SUBSYSTEM = "CALLBACK";
    private static boolean trace = log.isTraceEnabled();
    protected Map<String, ClientConsumer> callbackHandlers = new ConcurrentReaderHashMap();
    protected ConnectionFactoryCallbackHandler connectionfactoryCallbackHandler;

    public void handleCallback(Callback callback) throws HandleCallbackException {
        Object parameter = callback.getParameter();
        if (parameter instanceof ClientDelivery) {
            ClientDelivery dr = (ClientDelivery)parameter;
            ClientConsumer handler = this.callbackHandlers.get(dr.getConsumerId());
            if (handler == null) {
                throw new IllegalStateException(this + " callback handler not found, message arrived after consumer is closed.");
            }
            try {
                handler.handleMessage(dr);
            }
            catch (Exception e) {
                log.error((Object)"Failed to handle message", (Throwable)e);
                throw new HandleCallbackException(e.getMessage(), (Throwable)e);
            }
        } else if (parameter instanceof ConnectionFactoryUpdate) {
            if (this.connectionfactoryCallbackHandler == null) {
                log.warn((Object)"ConnectionFactoryUpdate was received but there is no callbackHandler set");
            } else {
                ConnectionFactoryUpdate viewChange = (ConnectionFactoryUpdate)parameter;
                if (trace) {
                    log.trace((Object)(this + " receiving cluster view change " + viewChange));
                }
                this.connectionfactoryCallbackHandler.handleMessage(viewChange);
            }
        } else {
            throw new HandleCallbackException("Unknow callback type: " + callback);
        }
    }

    public void registerHandler(String consumerID, ClientConsumer handler) {
        this.callbackHandlers.put(consumerID, handler);
    }

    public ClientConsumer unregisterHandler(String consumerID) {
        return this.callbackHandlers.remove(consumerID);
    }

    public ConnectionFactoryCallbackHandler getConnectionfactoryCallbackHandler() {
        return this.connectionfactoryCallbackHandler;
    }

    public void setConnectionfactoryCallbackHandler(ConnectionFactoryCallbackHandler connectionfactoryCallbackHandler) {
        this.connectionfactoryCallbackHandler = connectionfactoryCallbackHandler;
    }

    public String toString() {
        return "CallbackManager[" + Integer.toHexString(this.hashCode()) + "]";
    }
}

