/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.registry.basic;

import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.registry.AbstractKernelRegistry;
import org.jboss.kernel.plugins.registry.basic.BasicKernelRegistryFactory;
import org.jboss.kernel.spi.event.KernelEvent;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryPlugin;

public class BasicKernelRegistry
extends AbstractKernelRegistry {
    protected BasicKernelRegistryFactory defaultFactory = new BasicKernelRegistryFactory();

    public BasicKernelRegistry() throws Exception {
        this.addKernelRegistryFactory(this.defaultFactory);
    }

    public void registerEntry(Object name, KernelRegistryEntry entry) {
        Kernel.checkConfigure();
        this.defaultFactory.registerEntry(name, entry);
        Object target = entry.getTarget();
        if (target != null && target instanceof KernelRegistryPlugin) {
            KernelRegistryPlugin factory = (KernelRegistryPlugin)target;
            this.addKernelRegistryFactory(factory);
        }
        if (this.hasListeners()) {
            KernelEvent event = this.createEvent("KERNEL_REGISTRY_REGISTERED", name);
            this.fireKernelEvent(event);
        }
    }

    public KernelRegistryEntry unregisterEntry(Object name) {
        Kernel.checkConfigure();
        KernelRegistryEntry entry = this.defaultFactory.unregisterEntry(name);
        Object target = entry.getTarget();
        if (target != null && target instanceof KernelRegistryPlugin) {
            KernelRegistryPlugin factory = (KernelRegistryPlugin)target;
            this.removeKernelRegistryFactory(factory);
        }
        if (this.hasListeners()) {
            KernelEvent event = this.createEvent("KERNEL_REGISTRY_UNREGISTERED", name);
            this.fireKernelEvent(event);
        }
        return entry;
    }
}

