/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.remoting.event;

import java.io.Serializable;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryExp;

public class CompositeQueryExp
implements QueryExp,
Serializable {
    static final long serialVersionUID = 6918797787135545210L;
    public static final int AND = 0;
    public static final int OR = 1;
    private int operator;
    private QueryExp[] exps;

    public CompositeQueryExp(QueryExp[] exp) {
        this(exp, 0);
    }

    public CompositeQueryExp(QueryExp[] exp, int operator) {
        this.exps = exp;
        this.operator = operator;
    }

    public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        for (int c = 0; c < this.exps.length; ++c) {
            if (this.exps[c] == null) continue;
            boolean value = this.exps[c].apply(objectName);
            if (value && this.operator == 1) {
                return true;
            }
            if (value || this.operator != 0) continue;
            return false;
        }
        return this.operator == 0;
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        for (int c = 0; c < this.exps.length; ++c) {
            if (this.exps[c] == null) continue;
            this.exps[c].setMBeanServer(mBeanServer);
        }
    }
}

