/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.activitystream;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activitystream.ActivityProcessor;
import org.exoplatform.social.core.activitystream.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activitystream.JCRStorage;
import org.exoplatform.social.core.activitystream.model.Activity;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.jcr.SocialDataLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityManager {
    private JCRStorage storage;
    private static final Log LOG = ExoLogger.getLogger(ActivityManager.class);
    private SortedSet<ActivityProcessor> processors;
    private IdentityManager identityManager;

    public ActivityManager(SocialDataLocation dataLocation, IdentityManager identityManager) {
        this.storage = new JCRStorage(dataLocation);
        this.processors = new TreeSet<ActivityProcessor>(ActivityManager.processorComparator());
        this.identityManager = identityManager;
    }

    public Activity getActivity(String activityId) {
        Activity activity = this.storage.load(activityId);
        this.processActivitiy(activity);
        return activity;
    }

    public void deleteActivity(String activityId) throws Exception {
        this.storage.deleteActivity(activityId);
    }

    public List<Activity> getActivities(Identity identity) throws Exception {
        return this.getActivities(identity, 0L, 20L);
    }

    public List<Activity> getActivities(Identity identity, long start, long limit) throws Exception {
        List<Activity> activities = this.storage.getActivities(identity, start, limit);
        for (Activity activity : activities) {
            this.processActivitiy(activity);
        }
        return activities;
    }

    public Activity saveActivity(Identity owner, Activity activity) throws Exception {
        Validate.notNull((Object)owner, (String)"owner must not be null.");
        long now = System.currentTimeMillis();
        if (activity.getId() == null) {
            activity.setPostedTime(now);
        }
        activity.setUpdatedTimestamp(now);
        if (activity.getUserId() == null) {
            activity.setUserId(owner.getId());
        }
        return this.storage.save(owner, activity);
    }

    public Activity saveActivity(Activity activity) throws Exception {
        Validate.notNull((Object)activity.getUserId(), (String)"activity.getUserId() must not be null.");
        Identity owner = this.identityManager.getIdentity(activity.getUserId());
        return this.saveActivity(owner, activity);
    }

    public void saveComment(Activity activity, Activity comment) throws Exception {
        Validate.notNull((Object)activity, (String)"activity must not be null.");
        Validate.notNull((Object)comment.getUserId(), (String)"comment.getUserId() must not be null.");
        Validate.notNull((Object)comment.getTitle(), (String)"comment.getTitle() must not be null.");
        if (comment.getId() != null) {
            comment.setUpdatedTimestamp(System.currentTimeMillis());
        } else {
            comment.setPostedTime(System.currentTimeMillis());
            comment.setUpdatedTimestamp(System.currentTimeMillis());
        }
        comment.setReplyToId("IS_COMMENT");
        comment = this.saveActivity(comment);
        String rawCommentIds = activity.getReplyToId();
        if (rawCommentIds == null) {
            rawCommentIds = "";
        }
        rawCommentIds = rawCommentIds + "," + comment.getId();
        activity.setReplyToId(rawCommentIds);
        this.saveActivity(activity);
    }

    public void saveLike(Activity activity, Identity identity) throws Exception {
        Object[] identityIds = activity.getLikeIdentityIds();
        if (ArrayUtils.contains((Object[])identityIds, (Object)identity.getId())) {
            LOG.warn((Object)("activity is already liked by identity: " + identity));
            return;
        }
        identityIds = (String[])ArrayUtils.add((Object[])identityIds, (Object)identity.getId());
        activity.setLikeIdentityIds((String[])identityIds);
        this.saveActivity(activity);
    }

    public void removeLike(Activity activity, Identity identity) throws Exception {
        Object[] identityIds = activity.getLikeIdentityIds();
        if (ArrayUtils.contains((Object[])identityIds, (Object)identity.getId())) {
            identityIds = (String[])ArrayUtils.removeElement((Object[])identityIds, (Object)identity.getId());
            activity.setLikeIdentityIds((String[])identityIds);
            this.saveActivity(activity);
        } else {
            LOG.warn((Object)("activity is not liked by identity: " + identity));
        }
    }

    public List<Activity> getComments(Activity activity) {
        ArrayList<Activity> commentList = new ArrayList<Activity>();
        String rawCommentIds = activity.getReplyToId();
        if (rawCommentIds != null) {
            Object[] commentIds = rawCommentIds.split(",");
            for (Object commentId : commentIds = (String[])ArrayUtils.removeElement((Object[])commentIds, (Object)"")) {
                commentList.add(this.storage.load((String)commentId));
            }
        }
        return commentList;
    }

    public Activity recordActivity(Identity owner, String type, String title, String body) throws Exception {
        String userId = owner.getId();
        Activity activity = new Activity(userId, type, title, body);
        return this.saveActivity(owner, activity);
    }

    public Activity recordActivity(Identity owner, Activity activity) throws Exception {
        return this.saveActivity(owner, activity);
    }

    public void addProcessor(ActivityProcessor processor) {
        this.processors.add(processor);
        LOG.info((Object)("added activity processor " + processor.getClass()));
    }

    public void addProcessorPlugin(BaseActivityProcessorPlugin plugin) {
        this.addProcessor(plugin);
    }

    private static Comparator<ActivityProcessor> processorComparator() {
        return new Comparator<ActivityProcessor>(){

            @Override
            public int compare(ActivityProcessor p1, ActivityProcessor p2) {
                if (p1 == null || p1 == null) {
                    throw new IllegalArgumentException("Cannot compare null ActivityProcessor");
                }
                return p1.getPriority() - p2.getPriority();
            }
        };
    }

    void processActivitiy(Activity activity) {
        Iterator it = this.processors.iterator();
        while (it.hasNext()) {
            try {
                ((ActivityProcessor)it.next()).processActivity(activity);
            }
            catch (Exception e) {
                LOG.warn((Object)("activity processing failed " + e.getMessage()));
            }
        }
    }
}

