/*
 * Decompiled with CFR 0.152.
 */
package org.jnp.interfaces;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedSocketFactory
extends SocketFactory {
    private static Logger log = Logger.getLogger(TimedSocketFactory.class);
    public static final String JNP_TIMEOUT = "jnp.timeout";
    public static final String JNP_SO_TIMEOUT = "jnp.sotimeout";
    protected int timeout = 0;
    protected int soTimeout = 0;

    public TimedSocketFactory() {
    }

    public TimedSocketFactory(Hashtable<String, ?> env) {
        String value = (String)env.get(JNP_TIMEOUT);
        if (value != null) {
            this.timeout = Integer.parseInt(value);
        }
        if ((value = (String)env.get(JNP_SO_TIMEOUT)) != null) {
            this.soTimeout = Integer.parseInt(value);
        }
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        InetAddress hostAddr = InetAddress.getByName(host);
        return this.createSocket(hostAddr, port, null, 0);
    }

    @Override
    public Socket createSocket(InetAddress hostAddr, int port) throws IOException {
        return this.createSocket(hostAddr, port, null, 0);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException, UnknownHostException {
        InetAddress hostAddr = InetAddress.getByName(host);
        return this.createSocket(hostAddr, port, localAddr, localPort);
    }

    @Override
    public Socket createSocket(InetAddress hostAddr, int port, InetAddress localAddr, int localPort) throws IOException {
        log.debug("createSocket, hostAddr: " + hostAddr + ", port: " + port + ", localAddr: " + localAddr + ", localPort: " + localPort + ", timeout: " + this.timeout);
        Socket socket = new Socket();
        InetSocketAddress connectAddr = new InetSocketAddress(hostAddr, port);
        if (localAddr != null) {
            InetSocketAddress bindAddr = new InetSocketAddress(localAddr, localPort);
            socket.bind(bindAddr);
        }
        socket.setSoTimeout(this.soTimeout);
        socket.connect(connectAddr, this.timeout);
        return socket;
    }
}

