/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

@Serialized
public class ResourceValidator
implements Validator {
    public void validate(UIFormInput uiInput) throws Exception {
        String s;
        String label;
        if (uiInput == null || ((String)uiInput.getValue()).trim().length() == 0) {
            return;
        }
        UIComponent uiComponent = (UIComponent)((Object)uiInput);
        UIForm uiForm = uiComponent.getAncestorOfType(UIForm.class);
        try {
            label = uiForm.getLabel(uiInput.getName());
        }
        catch (Exception e) {
            label = uiInput.getName();
        }
        label = label.trim();
        if (label.charAt(label.length() - 1) == ':') {
            label = label.substring(0, label.length() - 1);
        }
        if (Character.isDigit((s = (String)uiInput.getValue()).charAt(0)) || s.charAt(0) == '-' || s.charAt(0) == '.' || s.charAt(0) == '_') {
            Object[] args = new Object[]{label, uiInput.getBindingField()};
            throw new MessageException(new ApplicationMessage("FirstCharacterNameValidator.msg", args, 1));
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-' || c == '.') continue;
            Object[] args = new Object[]{label, uiInput.getBindingField()};
            throw new MessageException(new ApplicationMessage("ResourceValidator.msg.Invalid-char", args, 1));
        }
    }
}

