/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import java.util.Collection;
import org.apache.shindig.protocol.ProtocolException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerPreconditions {
    private HandlerPreconditions() {
    }

    public static void requireNotEmpty(Collection<?> coll, String message) throws ProtocolException {
        if (coll.isEmpty()) {
            throw new ProtocolException(400, message);
        }
    }

    public static void requireEmpty(Collection<?> coll, String message) throws ProtocolException {
        if (!coll.isEmpty()) {
            throw new ProtocolException(400, message);
        }
    }

    public static void requireSingular(Collection<?> coll, String message) throws ProtocolException {
        if (coll.size() != 1) {
            throw new ProtocolException(400, message);
        }
    }

    public static void requirePlural(Collection<?> coll, String message) throws ProtocolException {
        if (coll.size() <= 1) {
            throw new ProtocolException(400, message);
        }
    }
}

