/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizationIdentityProvider
extends IdentityProvider<User> {
    private OrganizationService organizationService;
    public static final String NAME = "organization";
    private Map<String, User> userCache = new HashMap<String, User>();

    public OrganizationIdentityProvider(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> getAllUserId() {
        try {
            PageList pl = this.organizationService.getUserHandler().findUsers(new Query());
            List userList = pl.getAll();
            ArrayList<String> userIds = new ArrayList<String>();
            for (User user : userList) {
                userIds.add(user.getUserName());
            }
            return userIds;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load all users");
        }
    }

    private User getUserFromCache(String userName) {
        return this.userCache.get(userName);
    }

    private void addUserToCache(User user) {
        if (this.getUserFromCache(user.getUserName()) == null) {
            this.userCache.put(user.getUserName(), user);
        }
    }

    private void refreshCache() {
        this.userCache.clear();
    }

    @Override
    public User findByRemoteId(String remoteId) {
        User user;
        try {
            UserHandler userHandler = this.organizationService.getUserHandler();
            user = userHandler.findUserByName(remoteId);
        }
        catch (Exception e) {
            return null;
        }
        return user;
    }

    @Override
    public Identity createIdentity(User user) {
        Identity identity = new Identity(NAME, user.getUserName());
        return identity;
    }

    @Override
    public void populateProfile(Profile profile, User user) {
        profile.setProperty("firstName", user.getFirstName());
        profile.setProperty("lastName", user.getLastName());
        profile.setProperty("username", user.getUserName());
        String url = "/" + PortalContainer.getCurrentPortalContainerName() + "/private/classic/profile/" + user.getUserName();
        profile.setProperty("Url", url);
        if (user.getEmail() != null && !profile.contains("emails")) {
            ArrayList emails = new ArrayList();
            HashMap<String, String> email = new HashMap<String, String>();
            email.put("key", "work");
            email.put("value", user.getEmail());
            emails.add(email);
            profile.setProperty("emails", emails);
        }
    }
}

