/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.webui.activity.SpaceActivityListAccess;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPageIterator;

@ComponentConfig(template="classpath:groovy/social/webui/space/UISpaceActivitiesDisplay.gtmpl")
public class UISpaceActivitiesDisplay
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UISpaceActivitiesDisplay.class);
    private Space space;
    private UIActivitiesContainer uiActivitiesContainer;
    private UIPageIterator pageIterator;
    private static final int ACTIVITY_PER_PAGE = 10;

    public void setSpace(Space space) throws Exception {
        this.space = space;
        this.init();
    }

    public Space getSpace() {
        return this.space;
    }

    private void init() throws Exception {
        if (this.space == null) {
            LOG.warn((Object)"space is null! Can not display spaceActivites");
            return;
        }
        this.removeChild(UIPageIterator.class);
        this.pageIterator = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UIActivitiesPageIterator");
        this.removeChild(UIActivitiesContainer.class);
        this.uiActivitiesContainer = (UIActivitiesContainer)this.addChild(UIActivitiesContainer.class, null, null);
        this.uiActivitiesContainer.setPostContext(UIComposer.PostContext.SPACE);
        this.uiActivitiesContainer.setSpace(this.space);
    }

    private void bindDataToActivitiesContainer() throws Exception {
        int currentPage = this.pageIterator.getCurrentPage();
        LazyPageList pageList = new LazyPageList((ListAccess)new SpaceActivityListAccess(this.space), 10);
        this.pageIterator.setPageList((PageList)pageList);
        int pageCount = this.pageIterator.getAvailablePage();
        if (pageCount >= currentPage) {
            this.pageIterator.setCurrentPage(currentPage);
        } else if (pageCount < currentPage) {
            this.pageIterator.setCurrentPage(currentPage - 1);
        }
        this.uiActivitiesContainer.setActivityList(this.pageIterator.getCurrentPageData());
    }

    private IdentityManager getIdentityManager() {
        return (IdentityManager)this.getApplicationComponent(IdentityManager.class);
    }

    private ActivityManager getActivityManager() {
        return (ActivityManager)this.getApplicationComponent(ActivityManager.class);
    }
}

