/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import java.io.Serializable;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

public class IdentifierValidator
implements Validator,
Serializable {
    public void validate(UIFormInput uiInput) throws Exception {
        String label;
        if (uiInput.getValue() == null || ((String)uiInput.getValue()).trim().length() == 0) {
            return;
        }
        UIComponent uiComponent = (UIComponent)((Object)uiInput);
        UIForm uiForm = uiComponent.getAncestorOfType(UIForm.class);
        try {
            label = uiForm.getId() + ".label." + uiInput.getName();
        }
        catch (Exception e) {
            label = uiInput.getName();
        }
        String s = (String)uiInput.getValue();
        if (Character.isDigit(s.charAt(0)) || s.charAt(0) == '-') {
            Object[] args = new Object[]{label, uiInput.getBindingField()};
            throw new MessageException(new ApplicationMessage("FirstAndSpecialCharacterNameValidator.msg", args, 1));
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-') continue;
            Object[] args = new Object[]{label};
            throw new MessageException(new ApplicationMessage("IdentifierValidator.msg.Invalid-char", args, 1));
        }
    }
}

